/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FileSystemValidator;
import org.apache.flink.table.descriptors.OldCsvValidator;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.sinks.CsvTableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.TableSchemaUtils;

@Internal
public abstract class CsvTableSinkFactoryBase
implements TableFactory {
    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", "filesystem");
        context.put("format.type", "csv");
        context.put("connector.property-version", "1");
        context.put("format.property-version", "1");
        return context;
    }

    public List<String> supportedProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("connector.path");
        properties.add("format.fields.#.type");
        properties.add("format.fields.#.data-type");
        properties.add("format.fields.#.name");
        properties.add("format.derive-schema");
        properties.add("format.field-delimiter");
        properties.add("connector.path");
        properties.add("schema.#.type");
        properties.add("schema.#.data-type");
        properties.add("schema.#.name");
        properties.add("schema.watermark.*");
        return properties;
    }

    protected CsvTableSink createTableSink(Boolean isStreaming, Map<String, String> properties) {
        TableSchema formatSchema;
        DescriptorProperties params = new DescriptorProperties();
        params.putProperties(properties);
        new FileSystemValidator().validate(params);
        new OldCsvValidator().validate(params);
        new SchemaValidator(isStreaming, false, false).validate(params);
        TableSchema tableSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)params.getTableSchema("schema"));
        boolean hasSchema = params.hasPrefix("format.fields");
        if (hasSchema && !(formatSchema = params.getTableSchema("format.fields")).equals((Object)tableSchema)) {
            throw new TableException("Encodings that differ from the schema are not supported yet for CsvTableSink.");
        }
        String path = params.getString("connector.path");
        String fieldDelimiter = params.getOptionalString("format.field-delimiter").orElse(",");
        DataType[] dataTypes = (DataType[])Arrays.stream(tableSchema.getFieldDataTypes()).map(dt -> {
            switch (dt.getLogicalType().getTypeRoot()) {
                case TIMESTAMP_WITHOUT_TIME_ZONE: {
                    return dt.bridgedTo(Timestamp.class);
                }
                case TIME_WITHOUT_TIME_ZONE: {
                    return dt.bridgedTo(Time.class);
                }
                case DATE: {
                    return dt.bridgedTo(Date.class);
                }
            }
            return dt;
        }).toArray(DataType[]::new);
        return new CsvTableSink(path, fieldDelimiter, -1, null, tableSchema.getFieldNames(), dataTypes);
    }
}

