/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.container;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.connector.testframe.container.FlinkContainers;
import org.apache.flink.connector.testframe.container.FlinkContainersSettings;
import org.apache.flink.connector.testframe.container.FlinkImageBuilder;
import org.apache.flink.connector.testframe.container.ImageBuildException;
import org.apache.flink.connector.testframe.container.TestcontainersSettings;
import org.slf4j.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

class FlinkTestcontainersConfigurator {
    private final TestcontainersSettings testcontainersSettings;
    private final FlinkContainersSettings flinkContainersSettings;

    FlinkTestcontainersConfigurator(FlinkContainersSettings flinkContainersSettings, TestcontainersSettings testcontainersSettings) {
        this.testcontainersSettings = testcontainersSettings;
        this.flinkContainersSettings = flinkContainersSettings;
    }

    private GenericContainer<?> configureJobManagerContainer(Path tempDirectory) {
        ImageFromDockerfile jobManagerImage;
        Configuration jobManagerConf = new Configuration();
        jobManagerConf.addAll(this.flinkContainersSettings.getFlinkConfig());
        try {
            jobManagerImage = new FlinkImageBuilder().setTempDirectory(tempDirectory).setConfiguration(jobManagerConf).setLogProperties(this.flinkContainersSettings.getLogProperties()).setBaseImage(this.flinkContainersSettings.getBaseImage()).asJobManager().build();
        }
        catch (ImageBuildException e) {
            throw new RuntimeException("Failed to build JobManager image", e);
        }
        return this.configureContainer(new GenericContainer((Future)jobManagerImage), this.flinkContainersSettings.getJobManagerHostname(), "JobManager").withExposedPorts(new Integer[]{(Integer)jobManagerConf.get(RestOptions.PORT)});
    }

    private List<GenericContainer<?>> configureTaskManagerContainers(Path tempDirectory) {
        ArrayList taskManagers = new ArrayList();
        for (int i = 0; i < this.flinkContainersSettings.getNumTaskManagers(); ++i) {
            ImageFromDockerfile taskManagerImage;
            Configuration taskManagerConf = new Configuration();
            taskManagerConf.addAll(this.flinkContainersSettings.getFlinkConfig());
            String taskManagerHostName = this.flinkContainersSettings.getTaskManagerHostnamePrefix() + i;
            taskManagerConf.set(TaskManagerOptions.HOST, (Object)taskManagerHostName);
            try {
                taskManagerImage = new FlinkImageBuilder().setTempDirectory(tempDirectory).setConfiguration(taskManagerConf).setLogProperties(this.flinkContainersSettings.getLogProperties()).setBaseImage(this.flinkContainersSettings.getBaseImage()).asTaskManager().build();
            }
            catch (ImageBuildException e) {
                throw new RuntimeException("Failed to build TaskManager image", e);
            }
            taskManagers.add(this.configureContainer(new GenericContainer((Future)taskManagerImage), taskManagerHostName, "TaskManager-" + i));
        }
        return taskManagers;
    }

    private GenericContainer<?> configureZookeeperContainer() {
        return this.configureContainer(new GenericContainer(DockerImageName.parse((String)"zookeeper").withTag("3.5.9")), this.flinkContainersSettings.getZookeeperHostname(), "Zookeeper");
    }

    private GenericContainer<?> configureContainer(GenericContainer<?> container, String networkAlias, String logPrefix) {
        for (GenericContainer<?> dependentContainer : this.testcontainersSettings.getDependencies()) {
            dependentContainer.withNetwork(this.testcontainersSettings.getNetwork());
            container.dependsOn(new Startable[]{dependentContainer});
        }
        container.withNetwork(this.testcontainersSettings.getNetwork());
        container.withNetworkAliases(new String[]{networkAlias});
        Logger logger = this.testcontainersSettings.getLogger();
        if (logger != null) {
            container.withLogConsumer((Consumer)new Slf4jLogConsumer(logger).withPrefix(logPrefix));
        }
        container.withEnv(this.testcontainersSettings.getEnvVars());
        container.withWorkingDirectory(this.flinkContainersSettings.getFlinkHome());
        return container;
    }

    public FlinkContainers configure() {
        Path imageBuildingTempDir;
        try {
            imageBuildingTempDir = Files.createTempDirectory("flink-image-build", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary directory", e);
        }
        GenericContainer<?> jobManager = this.configureJobManagerContainer(imageBuildingTempDir);
        List<GenericContainer<?>> taskManagers = this.configureTaskManagerContainers(imageBuildingTempDir);
        GenericContainer<?> zookeeper = null;
        if (this.flinkContainersSettings.isZookeeperHA().booleanValue()) {
            zookeeper = this.configureZookeeperContainer();
            this.createTempDirAndMountToContainer("flink-recovery", this.flinkContainersSettings.getHaStoragePath(), jobManager);
        }
        this.createTempDirAndMountToContainer("flink-checkpoint", this.flinkContainersSettings.getCheckpointPath(), jobManager);
        return new FlinkContainers(jobManager, taskManagers, zookeeper, this.flinkContainersSettings.getFlinkConfig());
    }

    void createTempDirAndMountToContainer(String tempDirPrefix, String containerPath, GenericContainer<?> container) {
        try {
            Path tempDirPath = Files.createTempDirectory(tempDirPrefix, new FileAttribute[0]);
            File file = tempDirPath.toFile();
            file.setReadable(true, false);
            file.setWritable(true, false);
            file.setExecutable(true, false);
            container.withFileSystemBind(tempDirPath.toAbsolutePath().toString(), containerPath);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temporary recovery directory", e);
        }
    }
}

