/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.profiler.Profiler;
import org.apache.dubbo.common.profiler.ProfilerEntry;
import org.apache.dubbo.common.profiler.ProfilerSwitch;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncContextImpl;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

public abstract class AbstractProxyInvoker<T>
implements Invoker<T> {
    ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractProxyInvoker.class);
    private final T proxy;
    private final Class<T> type;
    private final URL url;

    public AbstractProxyInvoker(T proxy, Class<T> type, URL url) {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy == null");
        }
        if (type == null) {
            throw new IllegalArgumentException("interface == null");
        }
        if (!type.isInstance(proxy)) {
            throw new IllegalArgumentException(proxy.getClass().getName() + " not implement interface " + type);
        }
        this.proxy = proxy;
        this.type = type;
        this.url = url;
    }

    @Override
    public Class<T> getInterface() {
        return this.type;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Result invoke(Invocation invocation) throws RpcException {
        try {
            Object fromInvocation;
            Object fromInvocation2;
            ProfilerEntry originEntry = null;
            if (ProfilerSwitch.isEnableSimpleProfiler() && (fromInvocation2 = invocation.get("DUBBO_INVOKE_PROFILER")) instanceof ProfilerEntry) {
                ProfilerEntry profiler = Profiler.enter((ProfilerEntry)fromInvocation2, "Receive request. Server biz impl invoke begin.");
                invocation.put("DUBBO_INVOKE_PROFILER", profiler);
                originEntry = Profiler.setToBizProfiler(profiler);
            }
            Object value = this.doInvoke(this.proxy, invocation.getMethodName(), invocation.getParameterTypes(), invocation.getArguments());
            if (ProfilerSwitch.isEnableSimpleProfiler() && (fromInvocation = invocation.get("DUBBO_INVOKE_PROFILER")) instanceof ProfilerEntry) {
                ProfilerEntry profiler = Profiler.release((ProfilerEntry)fromInvocation);
                invocation.put("DUBBO_INVOKE_PROFILER", profiler);
            }
            Profiler.removeBizProfiler();
            if (originEntry != null) {
                Profiler.setToBizProfiler(originEntry);
            }
            CompletableFuture<Object> future = this.wrapWithFuture(value, invocation);
            CompletionStage appResponseFuture = future.handle((obj, t) -> {
                AppResponse result = new AppResponse(invocation);
                if (t != null) {
                    if (t instanceof CompletionException) {
                        result.setException(t.getCause());
                    } else {
                        result.setException((Throwable)t);
                    }
                } else {
                    result.setValue(obj);
                }
                return result;
            });
            return new AsyncRpcResult((CompletableFuture<AppResponse>)appResponseFuture, invocation);
        }
        catch (InvocationTargetException e) {
            if (RpcContext.getServiceContext().isAsyncStarted() && !RpcContext.getServiceContext().stopAsync()) {
                this.logger.error("3-5", "", "", "Provider async started, but got an exception from the original method, cannot write the exception back to consumer because an async result may have returned the new thread.", e);
            }
            return AsyncRpcResult.newDefaultAsyncResult(null, e.getTargetException(), invocation);
        }
        catch (Throwable e) {
            throw new RpcException("Failed to invoke remote proxy method " + invocation.getMethodName() + " to " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    private CompletableFuture<Object> wrapWithFuture(Object value, Invocation invocation) {
        if (value instanceof CompletableFuture) {
            invocation.put("PROVIDER_ASYNC", Boolean.TRUE);
            return (CompletableFuture)value;
        }
        if (RpcContext.getServerAttachment().isAsyncStarted()) {
            invocation.put("PROVIDER_ASYNC", Boolean.TRUE);
            return ((AsyncContextImpl)RpcContext.getServerAttachment().getAsyncContext()).getInternalFuture();
        }
        return CompletableFuture.completedFuture(value);
    }

    protected abstract Object doInvoke(T var1, String var2, Class<?>[] var3, Object[] var4) throws Throwable;

    public String toString() {
        return this.getInterface() + " -> " + (this.getUrl() == null ? " " : this.getUrl().toString());
    }
}

