/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.tri.compressor.DeCompressor;
import org.apache.dubbo.rpc.protocol.tri.frame.Deframer;

public class TriDecoder
implements Deframer {
    private static final int HEADER_LENGTH = 5;
    private static final int COMPRESSED_FLAG_MASK = 1;
    private static final int RESERVED_MASK = 254;
    private final CompositeByteBuf accumulate = Unpooled.compositeBuffer();
    private final Listener listener;
    private final DeCompressor decompressor;
    private boolean compressedFlag;
    private long pendingDeliveries;
    private boolean inDelivery = false;
    private boolean closing;
    private boolean closed;
    private int requiredLength = 5;
    private GrpcDecodeState state = GrpcDecodeState.HEADER;

    public TriDecoder(DeCompressor decompressor, Listener listener) {
        this.decompressor = decompressor;
        this.listener = listener;
    }

    @Override
    public void deframe(ByteBuf data) {
        if (this.closing || this.closed) {
            return;
        }
        this.accumulate.addComponent(true, data);
        this.deliver();
    }

    @Override
    public void request(int numMessages) {
        this.pendingDeliveries += (long)numMessages;
        this.deliver();
    }

    @Override
    public void close() {
        this.closing = true;
        this.deliver();
    }

    private void deliver() {
        if (this.inDelivery) {
            return;
        }
        this.inDelivery = true;
        try {
            block7: while (this.pendingDeliveries > 0L && this.hasEnoughBytes()) {
                switch (this.state) {
                    case HEADER: {
                        this.processHeader();
                        continue block7;
                    }
                    case PAYLOAD: {
                        this.processBody();
                        --this.pendingDeliveries;
                        continue block7;
                    }
                }
                throw new AssertionError((Object)("Invalid state: " + (Object)((Object)this.state)));
            }
            if (this.closing && !this.closed) {
                this.closed = true;
                this.accumulate.clear();
                this.accumulate.release();
                this.listener.close();
            }
        }
        finally {
            this.inDelivery = false;
        }
    }

    private boolean hasEnoughBytes() {
        return this.requiredLength - this.accumulate.readableBytes() <= 0;
    }

    private void processHeader() {
        short type = this.accumulate.readUnsignedByte();
        if ((type & 0xFE) != 0) {
            throw new RpcException("gRPC frame header malformed: reserved bits not zero");
        }
        this.compressedFlag = (type & 1) != 0;
        this.requiredLength = this.accumulate.readInt();
        this.state = GrpcDecodeState.PAYLOAD;
    }

    private void processBody() {
        byte[] stream = this.compressedFlag ? this.getCompressedBody() : this.getUncompressedBody();
        this.listener.onRawMessage(stream);
        this.state = GrpcDecodeState.HEADER;
        this.requiredLength = 5;
    }

    private byte[] getCompressedBody() {
        byte[] compressedBody = this.getUncompressedBody();
        return this.decompressor.decompress(compressedBody);
    }

    private byte[] getUncompressedBody() {
        byte[] data = new byte[this.requiredLength];
        this.accumulate.readBytes(data);
        return data;
    }

    private static enum GrpcDecodeState {
        HEADER,
        PAYLOAD;

    }

    public static interface Listener {
        public void onRawMessage(byte[] var1);

        public void close();
    }
}

