/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo.filter;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"})
public class TraceFilter
implements Filter {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(TraceFilter.class);
    private static final String TRACE_MAX = "trace.max";
    private static final String TRACE_COUNT = "trace.count";
    private static final ConcurrentMap<String, Set<Channel>> TRACERS = new ConcurrentHashMap<String, Set<Channel>>();

    public static void addTracer(Class<?> type, String method, Channel channel, int max) {
        channel.setAttribute(TRACE_MAX, max);
        channel.setAttribute(TRACE_COUNT, new AtomicInteger());
        String key = StringUtils.isNotEmpty(method) ? type.getName() + "." + method : type.getName();
        Set channels = TRACERS.computeIfAbsent(key, k -> new ConcurrentHashSet());
        channels.add(channel);
    }

    public static void removeTracer(Class<?> type, String method, Channel channel) {
        channel.removeAttribute(TRACE_MAX);
        channel.removeAttribute(TRACE_COUNT);
        String key = StringUtils.isNotEmpty(method) ? type.getName() + "." + method : type.getName();
        Set channels = (Set)TRACERS.get(key);
        if (channels != null) {
            channels.remove(channel);
        }
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        long start = System.currentTimeMillis();
        Result result = invoker.invoke(invocation);
        long end = System.currentTimeMillis();
        if (TRACERS.size() > 0) {
            String key = invoker.getInterface().getName() + "." + invocation.getMethodName();
            Set channels = (Set)TRACERS.get(key);
            if (CollectionUtils.isEmpty(channels)) {
                key = invoker.getInterface().getName();
                channels = (Set)TRACERS.get(key);
            }
            if (CollectionUtils.isNotEmpty(channels)) {
                for (Channel channel : new ArrayList(channels)) {
                    if (channel.isConnected()) {
                        try {
                            int count;
                            AtomicInteger c;
                            int max = 1;
                            Integer m = (Integer)channel.getAttribute(TRACE_MAX);
                            if (m != null) {
                                max = m;
                            }
                            if ((c = (AtomicInteger)channel.getAttribute(TRACE_COUNT)) == null) {
                                c = new AtomicInteger();
                                channel.setAttribute(TRACE_COUNT, c);
                            }
                            if ((count = c.getAndIncrement()) < max) {
                                String prompt = channel.getUrl().getParameter("prompt", "dubbo>");
                                channel.send("\r\n" + RpcContext.getServiceContext().getRemoteAddress() + " -> " + invoker.getInterface().getName() + "." + invocation.getMethodName() + "(" + JsonUtils.getJson().toJson(invocation.getArguments()) + ") -> " + JsonUtils.getJson().toJson(result.getValue()) + "\r\nelapsed: " + (end - start) + " ms.\r\n\r\n" + prompt);
                            }
                            if (count < max - 1) continue;
                            channels.remove(channel);
                        }
                        catch (Throwable e) {
                            channels.remove(channel);
                            logger.warn("4-9", "", "", e.getMessage(), e);
                        }
                        continue;
                    }
                    channels.remove(channel);
                }
            }
        }
        return result;
    }
}

