/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds.util.protocol.message;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.utils.ConcurrentHashSet;

public class RouteResult {
    private final Map<String, Set<String>> domainMap;

    public RouteResult() {
        this.domainMap = new ConcurrentHashMap<String, Set<String>>();
    }

    public RouteResult(Map<String, Set<String>> domainMap) {
        this.domainMap = domainMap;
    }

    public boolean isNotEmpty() {
        return !this.domainMap.isEmpty();
    }

    public Set<String> searchDomain(String domain) {
        return this.domainMap.getOrDefault(domain, new ConcurrentHashSet());
    }

    public Set<String> getDomains() {
        return Collections.unmodifiableSet(this.domainMap.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteResult that = (RouteResult)o;
        return Objects.equals(this.domainMap, that.domainMap);
    }

    public int hashCode() {
        return Objects.hash(this.domainMap);
    }

    public String toString() {
        return "RouteResult{domainMap=" + this.domainMap + '}';
    }
}

