/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds.istio;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import istio.v1.auth.IstioCertificateRequest;
import istio.v1.auth.IstioCertificateResponse;
import istio.v1.auth.IstioCertificateServiceGrpc;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.xds.XdsCertificateSigner;
import org.apache.dubbo.registry.xds.istio.IstioEnv;
import org.apache.dubbo.rpc.RpcException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class IstioCitadelCertificateSigner
implements XdsCertificateSigner {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(IstioCitadelCertificateSigner.class);
    private final IstioEnv istioEnv;
    private XdsCertificateSigner.CertPair certPair;

    public IstioCitadelCertificateSigner() {
        ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
        scheduledThreadPool.scheduleAtFixedRate(new GenerateCertTask(), 0L, 30L, TimeUnit.SECONDS);
        this.istioEnv = IstioEnv.getInstance();
    }

    @Override
    public XdsCertificateSigner.CertPair GenerateCert(URL url) {
        if (this.certPair != null && !this.certPair.isExpire()) {
            return this.certPair;
        }
        return this.doGenerateCert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XdsCertificateSigner.CertPair doGenerateCert() {
        IstioCitadelCertificateSigner istioCitadelCertificateSigner = this;
        synchronized (istioCitadelCertificateSigner) {
            if (this.certPair == null || this.certPair.isExpire()) {
                try {
                    this.certPair = this.createCert();
                }
                catch (IOException e) {
                    logger.error("1-26", "", "", "Generate Cert from Istio failed.", e);
                    throw new RpcException("Generate Cert from Istio failed.", (Throwable)e);
                }
            }
        }
        return this.certPair;
    }

    public XdsCertificateSigner.CertPair createCert() throws IOException {
        PublicKey publicKey = null;
        PrivateKey privateKey = null;
        ContentSigner signer = null;
        if (this.istioEnv.isECCFirst()) {
            try {
                ECGenParameterSpec ecSpec = new ECGenParameterSpec("secp256r1");
                KeyPairGenerator g = KeyPairGenerator.getInstance("EC");
                g.initialize(ecSpec, new SecureRandom());
                KeyPair keypair = g.generateKeyPair();
                publicKey = keypair.getPublic();
                privateKey = keypair.getPrivate();
                signer = new JcaContentSignerBuilder("SHA256withECDSA").build(keypair.getPrivate());
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | OperatorCreationException e) {
                logger.error("1-27", "", "", "Generate Key with secp256r1 algorithm failed. Please check if your system support. Will attempt to generate with RSA2048.", e);
            }
        }
        if (publicKey == null) {
            try {
                KeyPairGenerator kpGenerator = KeyPairGenerator.getInstance("RSA");
                kpGenerator.initialize(this.istioEnv.getRasKeySize());
                KeyPair keypair = kpGenerator.generateKeyPair();
                publicKey = keypair.getPublic();
                privateKey = keypair.getPrivate();
                signer = new JcaContentSignerBuilder("SHA256WithRSA").build(keypair.getPrivate());
            }
            catch (NoSuchAlgorithmException | OperatorCreationException e) {
                logger.error("1-27", "", "", "Generate Key with SHA256WithRSA algorithm failed. Please check if your system support.", e);
                throw new RpcException(e);
            }
        }
        String csr = this.generateCsr(publicKey, signer);
        ManagedChannel channel = NettyChannelBuilder.forTarget((String)this.istioEnv.getCaAddr()).sslContext(GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build()).build();
        Metadata header = new Metadata();
        Metadata.Key key = Metadata.Key.of((String)"authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        header.put(key, (Object)("Bearer " + this.istioEnv.getServiceAccount()));
        key = Metadata.Key.of((String)"ClusterID", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        header.put(key, (Object)this.istioEnv.getIstioMetaClusterId());
        IstioCertificateServiceGrpc.IstioCertificateServiceStub stub = IstioCertificateServiceGrpc.newStub((Channel)channel);
        stub = (IstioCertificateServiceGrpc.IstioCertificateServiceStub)MetadataUtils.attachHeaders((AbstractStub)stub, (Metadata)header);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        StringBuffer publicKeyBuilder = new StringBuffer();
        AtomicBoolean failed = new AtomicBoolean(false);
        stub.createCertificate(this.generateRequest(csr), this.generateResponseObserver(countDownLatch, publicKeyBuilder, failed));
        long expireTime = System.currentTimeMillis() + (long)((float)this.istioEnv.getSecretTTL() * this.istioEnv.getSecretGracePeriodRatio());
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new RpcException("Generate Cert Failed. Wait for cert failed.", (Throwable)e);
        }
        if (failed.get()) {
            throw new RpcException("Generate Cert Failed. Send csr request failed. Please check log above.");
        }
        String privateKeyPem = this.generatePrivatePemKey(privateKey);
        XdsCertificateSigner.CertPair certPair = new XdsCertificateSigner.CertPair(privateKeyPem, publicKeyBuilder.toString(), System.currentTimeMillis(), expireTime);
        channel.shutdown();
        return certPair;
    }

    private IstioCertificateRequest generateRequest(String csr) {
        return IstioCertificateRequest.newBuilder().setCsr(csr).setValidityDuration(this.istioEnv.getSecretTTL()).build();
    }

    private StreamObserver<IstioCertificateResponse> generateResponseObserver(final CountDownLatch countDownLatch, final StringBuffer publicKeyBuilder, final AtomicBoolean failed) {
        return new StreamObserver<IstioCertificateResponse>(){

            public void onNext(IstioCertificateResponse istioCertificateResponse) {
                for (int i = 0; i < istioCertificateResponse.getCertChainCount(); ++i) {
                    publicKeyBuilder.append(istioCertificateResponse.getCertChainBytes(i).toStringUtf8());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Receive Cert chain from Istio Citadel. \n" + publicKeyBuilder);
                }
                countDownLatch.countDown();
            }

            public void onError(Throwable throwable) {
                failed.set(true);
                logger.error("1-28", "", "", "Receive error message from Istio Citadel grpc stub.", throwable);
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
    }

    private String generatePrivatePemKey(PrivateKey privateKey) throws IOException {
        String key = this.generatePemKey("RSA PRIVATE KEY", privateKey.getEncoded());
        if (logger.isDebugEnabled()) {
            logger.debug("Generated Private Key. \n" + key);
        }
        return key;
    }

    private String generatePemKey(String type, byte[] content) throws IOException {
        PemObject pemObject = new PemObject(type, content);
        StringWriter str = new StringWriter();
        JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)str);
        jcaPEMWriter.writeObject((PemObjectGenerator)pemObject);
        jcaPEMWriter.close();
        str.close();
        return str.toString();
    }

    private String generateCsr(PublicKey publicKey, ContentSigner signer) throws IOException {
        GeneralNames subjectAltNames = new GeneralNames(new GeneralName[]{new GeneralName(6, this.istioEnv.getCsrHost())});
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.subjectAlternativeName, true, (ASN1Encodable)subjectAltNames);
        PKCS10CertificationRequest request = new JcaPKCS10CertificationRequestBuilder(new X500Name("O=" + this.istioEnv.getTrustDomain()), publicKey).addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate()).build(signer);
        String csr = this.generatePemKey("CERTIFICATE REQUEST", request.getEncoded());
        if (logger.isDebugEnabled()) {
            logger.debug("CSR Request to Istio Citadel. \n" + csr);
        }
        return csr;
    }

    private class GenerateCertTask
    implements Runnable {
        private GenerateCertTask() {
        }

        @Override
        public void run() {
            IstioCitadelCertificateSigner.this.doGenerateCert();
        }
    }
}

