/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.registry.NotifyListener;

public class NacosAggregateListener {
    private final NotifyListener notifyListener;
    private final Set<String> serviceNames = new ConcurrentHashSet<String>();
    private final Map<String, List<Instance>> serviceInstances = new ConcurrentHashMap<String, List<Instance>>();

    public NacosAggregateListener(NotifyListener notifyListener) {
        this.notifyListener = notifyListener;
    }

    public List<Instance> saveAndAggregateAllInstances(String serviceName, List<Instance> instances) {
        this.serviceNames.add(serviceName);
        if (instances == null) {
            this.serviceInstances.remove(serviceName);
        } else {
            this.serviceInstances.put(serviceName, instances);
        }
        return this.serviceInstances.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public NotifyListener getNotifyListener() {
        return this.notifyListener;
    }

    public Set<String> getServiceNames() {
        return this.serviceNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NacosAggregateListener that = (NacosAggregateListener)o;
        return Objects.equals(this.notifyListener, that.notifyListener) && Objects.equals(this.serviceNames, that.serviceNames) && Objects.equals(this.serviceInstances, that.serviceInstances);
    }

    public int hashCode() {
        return Objects.hash(this.notifyListener, this.serviceNames, this.serviceInstances);
    }
}

