/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.aggregate;

import java.util.concurrent.TimeUnit;

public class TimeWindowCounter {
    private final Long[] ringBuffer;
    private final Long[] bucketStartTimeMillis;
    private int currentBucket;
    private long lastRotateTimestampMillis;
    private final long durationBetweenRotatesMillis;

    public TimeWindowCounter(int bucketNum, int timeWindowSeconds) {
        this.ringBuffer = new Long[bucketNum];
        this.bucketStartTimeMillis = new Long[bucketNum];
        for (int i = 0; i < bucketNum; ++i) {
            this.ringBuffer[i] = 0L;
            this.bucketStartTimeMillis[i] = System.currentTimeMillis();
        }
        this.currentBucket = 0;
        this.lastRotateTimestampMillis = System.currentTimeMillis();
        this.durationBetweenRotatesMillis = TimeUnit.SECONDS.toMillis(timeWindowSeconds) / (long)bucketNum;
    }

    public synchronized double get() {
        return this.rotate().longValue();
    }

    public long bucketLivedSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.bucketStartTimeMillis[this.currentBucket]);
    }

    public synchronized void increment() {
        this.increment(1L);
    }

    public synchronized void increment(Long step) {
        this.rotate();
        for (int i = 0; i < this.ringBuffer.length; ++i) {
            this.ringBuffer[i] = this.ringBuffer[i] + step;
        }
    }

    public synchronized void decrement() {
        this.decrement(1L);
    }

    public synchronized void decrement(Long step) {
        this.rotate();
        for (int i = 0; i < this.ringBuffer.length; ++i) {
            this.ringBuffer[i] = this.ringBuffer[i] - step;
        }
    }

    private Long rotate() {
        long timeSinceLastRotateMillis = System.currentTimeMillis() - this.lastRotateTimestampMillis;
        while (timeSinceLastRotateMillis > this.durationBetweenRotatesMillis) {
            this.ringBuffer[this.currentBucket] = 0L;
            this.bucketStartTimeMillis[this.currentBucket] = this.lastRotateTimestampMillis + this.durationBetweenRotatesMillis;
            if (++this.currentBucket >= this.ringBuffer.length) {
                this.currentBucket = 0;
            }
            timeSinceLastRotateMillis -= this.durationBetweenRotatesMillis;
            this.lastRotateTimestampMillis += this.durationBetweenRotatesMillis;
        }
        return this.ringBuffer[this.currentBucket];
    }
}

