/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.report;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.resource.Disposable;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportFactory;
import org.apache.dubbo.metadata.report.support.NopMetadataReport;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetadataReportInstance
implements Disposable {
    private AtomicBoolean init = new AtomicBoolean(false);
    private String metadataType;
    private final Map<String, MetadataReport> metadataReports = new HashMap<String, MetadataReport>();
    private ApplicationModel applicationModel;
    private final NopMetadataReport nopMetadataReport;

    public MetadataReportInstance(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.nopMetadataReport = new NopMetadataReport();
    }

    public void init(List<MetadataReportConfig> metadataReportConfigs) {
        if (!this.init.compareAndSet(false, true)) {
            return;
        }
        this.metadataType = this.applicationModel.getApplicationConfigManager().getApplicationOrElseThrow().getMetadataType();
        if (this.metadataType == null) {
            this.metadataType = "local";
        }
        MetadataReportFactory metadataReportFactory = this.applicationModel.getExtensionLoader(MetadataReportFactory.class).getAdaptiveExtension();
        for (MetadataReportConfig metadataReportConfig : metadataReportConfigs) {
            this.init(metadataReportConfig, metadataReportFactory);
        }
    }

    private void init(MetadataReportConfig config, MetadataReportFactory metadataReportFactory) {
        URL url = config.toUrl();
        if ("metadata".equals(url.getProtocol())) {
            String protocol = url.getParameter("metadata", "dubbo");
            url = URLBuilder.from(url).setProtocol(protocol).setScopeModel(config.getScopeModel()).removeParameter("metadata").build();
        }
        url = url.addParameterIfAbsent("application", this.applicationModel.getCurrentConfig().getName());
        url = url.addParameterIfAbsent("file.cache", String.valueOf(this.applicationModel.getCurrentConfig().getEnableFileCache()));
        String relatedRegistryId = StringUtils.isEmpty(config.getRegistry()) ? (StringUtils.isEmpty(config.getId()) ? "default" : config.getId()) : config.getRegistry();
        MetadataReport metadataReport = metadataReportFactory.getMetadataReport(url);
        if (metadataReport != null) {
            this.metadataReports.put(relatedRegistryId, metadataReport);
        }
    }

    public Map<String, MetadataReport> getMetadataReports(boolean checked) {
        return this.metadataReports;
    }

    public MetadataReport getMetadataReport(String registryKey) {
        MetadataReport metadataReport = this.metadataReports.get(registryKey);
        if (metadataReport == null && this.metadataReports.size() > 0) {
            metadataReport = this.metadataReports.values().iterator().next();
        }
        return metadataReport;
    }

    public MetadataReport getNopMetadataReport() {
        return this.nopMetadataReport;
    }

    public String getMetadataType() {
        return this.metadataType;
    }

    public boolean inited() {
        return this.init.get();
    }

    @Override
    public void destroy() {
        this.metadataReports.forEach((_k, reporter) -> reporter.destroy());
        this.metadataReports.clear();
    }
}

