/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.reference;

import com.alibaba.spring.util.AnnotationUtils;
import com.alibaba.spring.util.ObjectUtils;
import java.beans.PropertyEditor;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.annotation.Argument;
import org.apache.dubbo.config.annotation.Method;
import org.apache.dubbo.config.spring.beans.factory.annotation.AnnotationPropertyValuesAdapter;
import org.apache.dubbo.config.spring.reference.ReferenceBeanSupport;
import org.apache.dubbo.config.spring.util.DubboAnnotationUtils;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

public class ReferenceCreator {
    static final String[] IGNORE_FIELD_NAMES = (String[])ObjectUtils.of((Object[])new String[]{"application", "module", "consumer", "monitor", "registry", "interfaceClass"});
    private static final String ONRETURN = "onreturn";
    private static final String ONTHROW = "onthrow";
    private static final String ONINVOKE = "oninvoke";
    private static final String ISRETURN = "isReturn";
    private static final String METHOD = "Method";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final Map<String, Object> attributes;
    protected final ApplicationContext applicationContext;
    protected final ClassLoader classLoader;
    protected Class<?> defaultInterfaceClass;
    private final ModuleModel moduleModel;

    private ReferenceCreator(Map<String, Object> attributes, ApplicationContext applicationContext) {
        Assert.notNull(attributes, (String)"The Annotation attributes must not be null!");
        Assert.notNull((Object)applicationContext, (String)"The ApplicationContext must not be null!");
        this.attributes = attributes;
        this.applicationContext = applicationContext;
        this.classLoader = applicationContext.getClassLoader() != null ? applicationContext.getClassLoader() : Thread.currentThread().getContextClassLoader();
        this.moduleModel = DubboBeanUtils.getModuleModel((BeanFactory)applicationContext);
        Assert.notNull((Object)this.moduleModel, (String)"ModuleModel not found in Spring ApplicationContext");
    }

    public final ReferenceConfig build() throws Exception {
        ReferenceConfig configBean = new ReferenceConfig();
        this.configureBean(configBean);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("The configBean[type:" + configBean.getClass().getSimpleName() + "<" + this.defaultInterfaceClass.getTypeName() + ">] has been built."));
        }
        return configBean;
    }

    protected void configureBean(ReferenceConfig referenceConfig) throws Exception {
        this.populateBean(referenceConfig);
        this.configureMonitorConfig(referenceConfig);
        this.configureModuleConfig(referenceConfig);
        this.configureConsumerConfig(referenceConfig);
    }

    private void configureMonitorConfig(ReferenceConfig configBean) {
        String monitorConfigId = (String)AnnotationUtils.getAttribute(this.attributes, (String)"monitor");
        if (StringUtils.hasText((String)monitorConfigId)) {
            MonitorConfig monitorConfig = this.getConfig(monitorConfigId, MonitorConfig.class);
            configBean.setMonitor(monitorConfig);
        }
    }

    private void configureModuleConfig(ReferenceConfig configBean) {
        String moduleConfigId = (String)AnnotationUtils.getAttribute(this.attributes, (String)"module");
        if (StringUtils.hasText((String)moduleConfigId)) {
            ModuleConfig moduleConfig = this.getConfig(moduleConfigId, ModuleConfig.class);
            configBean.setModule(moduleConfig);
        }
    }

    private void configureConsumerConfig(ReferenceConfig<?> referenceBean) {
        ConsumerConfig consumerConfig = null;
        Object consumer = AnnotationUtils.getAttribute(this.attributes, (String)"consumer");
        if (consumer != null) {
            if (consumer instanceof String) {
                consumerConfig = this.getConfig((String)consumer, ConsumerConfig.class);
            } else if (consumer instanceof ConsumerConfig) {
                consumerConfig = (ConsumerConfig)consumer;
            } else {
                throw new IllegalArgumentException("Unexpected 'consumer' attribute value: " + consumer);
            }
            referenceBean.setConsumer(consumerConfig);
        }
    }

    private <T extends AbstractConfig> T getConfig(String configIdOrName, Class<T> configType) {
        AbstractConfig config = this.moduleModel.getConfigManager().getConfig(configType, configIdOrName).orElse(null);
        if (config == null && this.applicationContext.containsBean(configIdOrName)) {
            config = (AbstractConfig)this.applicationContext.getBean(configIdOrName, configType);
        }
        if (config == null) {
            throw new IllegalArgumentException(configType.getSimpleName() + " not found: " + configIdOrName);
        }
        return (T)config;
    }

    protected void populateBean(ReferenceConfig referenceConfig) {
        Assert.notNull(this.defaultInterfaceClass, (String)"The default interface class cannot be empty!");
        ReferenceBeanSupport.convertReferenceProps(this.attributes, this.defaultInterfaceClass);
        DataBinder dataBinder = new DataBinder((Object)referenceConfig);
        dataBinder.registerCustomEditor(String.class, "filter", (PropertyEditor)new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(String.class, "listener", (PropertyEditor)new StringTrimmerEditor(true));
        DefaultConversionService conversionService = new DefaultConversionService();
        conversionService.addConverter(String[].class, Map.class, DubboAnnotationUtils::convertParameters);
        conversionService.addConverter(Map.class, MethodConfig.class, source -> this.createMethodConfig((Map<String, Object>)source, conversionService));
        conversionService.addConverter(Method.class, MethodConfig.class, source -> {
            AnnotationAttributes methodAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)source, (boolean)true, (String[])new String[0]);
            return this.createMethodConfig((Map<String, Object>)methodAttributes, conversionService);
        });
        conversionService.addConverter(Map.class, ArgumentConfig.class, source -> {
            ArgumentConfig argumentConfig = new ArgumentConfig();
            DataBinder argDataBinder = new DataBinder((Object)argumentConfig);
            argDataBinder.setConversionService((ConversionService)conversionService);
            argDataBinder.bind((PropertyValues)new AnnotationPropertyValuesAdapter((Map<String, Object>)source, (PropertyResolver)this.applicationContext.getEnvironment(), new String[0]));
            return argumentConfig;
        });
        conversionService.addConverter(Argument.class, ArgumentConfig.class, source -> {
            ArgumentConfig argumentConfig = new ArgumentConfig();
            DataBinder argDataBinder = new DataBinder((Object)argumentConfig);
            argDataBinder.setConversionService((ConversionService)conversionService);
            argDataBinder.bind((PropertyValues)new AnnotationPropertyValuesAdapter((Annotation)source, (PropertyResolver)this.applicationContext.getEnvironment(), new String[0]));
            return argumentConfig;
        });
        dataBinder.setConversionService((ConversionService)conversionService);
        dataBinder.bind((PropertyValues)new AnnotationPropertyValuesAdapter(this.attributes, (PropertyResolver)this.applicationContext.getEnvironment(), IGNORE_FIELD_NAMES));
    }

    private MethodConfig createMethodConfig(Map<String, Object> methodAttributes, DefaultConversionService conversionService) {
        String[] callbacks;
        for (String callbackName : callbacks = new String[]{ONINVOKE, ONRETURN, ONTHROW}) {
            Object value = methodAttributes.get(callbackName);
            if (!(value instanceof String)) continue;
            String strValue = (String)value;
            int index = strValue.lastIndexOf(".");
            if (index != -1) {
                String beanName = strValue.substring(0, index);
                String methodName = strValue.substring(index + 1);
                methodAttributes.put(callbackName, this.applicationContext.getBean(beanName));
                methodAttributes.put(callbackName + METHOD, methodName);
                continue;
            }
            methodAttributes.put(callbackName, this.applicationContext.getBean(strValue));
        }
        MethodConfig methodConfig = new MethodConfig();
        DataBinder mcDataBinder = new DataBinder((Object)methodConfig);
        methodConfig.setReturn((Boolean)methodAttributes.get(ISRETURN));
        mcDataBinder.setConversionService((ConversionService)conversionService);
        AnnotationPropertyValuesAdapter propertyValues = new AnnotationPropertyValuesAdapter(methodAttributes, (PropertyResolver)this.applicationContext.getEnvironment(), new String[0]);
        mcDataBinder.bind((PropertyValues)propertyValues);
        return methodConfig;
    }

    public static ReferenceCreator create(Map<String, Object> attributes, ApplicationContext applicationContext) {
        return new ReferenceCreator(attributes, applicationContext);
    }

    public ReferenceCreator defaultInterfaceClass(Class<?> interfaceClass) {
        this.defaultInterfaceClass = interfaceClass;
        return this;
    }
}

