/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceRepository;
import org.apache.dubbo.rpc.protocol.tri.AbstractServerStream;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Http2HeaderMeta;
import org.apache.dubbo.rpc.protocol.tri.PathResolver;
import org.apache.dubbo.rpc.protocol.tri.ServerTransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TripleRpcException;
import org.apache.dubbo.rpc.protocol.tri.TripleUtil;
import org.apache.dubbo.rpc.service.EchoService;
import org.apache.dubbo.rpc.service.GenericService;

public class TripleHttp2FrameServerHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleHttp2FrameServerHandler.class);
    private static final PathResolver PATH_RESOLVER = ExtensionLoader.getExtensionLoader(PathResolver.class).getDefaultExtension();

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            this.onHeadersRead(ctx, (Http2HeadersFrame)msg);
        } else if (msg instanceof Http2DataFrame) {
            this.onDataRead(ctx, (Http2DataFrame)msg);
        } else if (msg instanceof Http2Frame) {
            ReferenceCountUtil.release((Object)msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Exception in processing triple message", cause);
        }
        if (cause instanceof TripleRpcException) {
            TripleUtil.responseErr(ctx, ((TripleRpcException)cause).getStatus());
        } else {
            TripleUtil.responseErr(ctx, GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription("Provider's error:\n" + cause.getMessage()));
        }
    }

    public void onDataRead(ChannelHandlerContext ctx, Http2DataFrame msg) throws Exception {
        AbstractServerStream serverStream;
        super.channelRead(ctx, (Object)msg.content());
        if (msg.isEndStream() && (serverStream = TripleUtil.getServerStream(ctx)) != null) {
            serverStream.asTransportObserver().tryOnComplete();
        }
    }

    private Invoker<?> getInvoker(Http2Headers headers, String serviceName) {
        String version = headers.contains((Object)"tri-service-version") ? ((CharSequence)headers.get((Object)"tri-service-version")).toString() : null;
        String group = headers.contains((Object)"tri-service-group") ? ((CharSequence)headers.get((Object)"tri-service-group")).toString() : null;
        String key = URL.buildKey(serviceName, group, version);
        Invoker<?> invoker = PATH_RESOLVER.resolve(key);
        if (invoker == null) {
            invoker = PATH_RESOLVER.resolve(serviceName);
        }
        return invoker;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, Http2HeadersFrame msg) throws Exception {
        Http2Headers headers = msg.headers();
        if (!HttpMethod.POST.asciiName().contentEquals(headers.method())) {
            TripleUtil.responsePlainTextError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED.code(), GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription(String.format("Method '%s' is not supported", headers.method())));
            return;
        }
        if (headers.path() == null) {
            TripleUtil.responsePlainTextError(ctx, HttpResponseStatus.NOT_FOUND.code(), GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED.code).withDescription("Expected path but is missing"));
            return;
        }
        String path = headers.path().toString();
        if (path.charAt(0) != '/') {
            TripleUtil.responsePlainTextError(ctx, HttpResponseStatus.NOT_FOUND.code(), GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED.code).withDescription(String.format("Expected path to start with /: %s", path)));
            return;
        }
        CharSequence contentType = HttpUtil.getMimeType((CharSequence)((CharSequence)headers.get((Object)HttpHeaderNames.CONTENT_TYPE)));
        if (contentType == null) {
            TripleUtil.responsePlainTextError(ctx, HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE.code(), GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL.code).withDescription("Content-Type is missing from the request"));
            return;
        }
        String contentString = contentType.toString();
        if (!TripleUtil.supportContentType(contentString)) {
            TripleUtil.responsePlainTextError(ctx, HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE.code(), GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL.code).withDescription(String.format("Content-Type '%s' is not supported", contentString)));
            return;
        }
        String[] parts = path.split("/");
        if (parts.length != 3) {
            TripleUtil.responseErr(ctx, GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED).withDescription("Bad path format:" + path));
            return;
        }
        String serviceName = parts[1];
        String originalMethodName = parts[2];
        String methodName = Character.toLowerCase(originalMethodName.charAt(0)) + originalMethodName.substring(1);
        Invoker<?> invoker = this.getInvoker(headers, serviceName);
        if (invoker == null) {
            TripleUtil.responseErr(ctx, GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED).withDescription("Service not found:" + serviceName));
            return;
        }
        ServiceRepository repo = ApplicationModel.getServiceRepository();
        ServiceDescriptor serviceDescriptor = repo.lookupService(invoker.getUrl().getServiceKey());
        if (serviceDescriptor == null) {
            TripleUtil.responseErr(ctx, GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED).withDescription("Service not found:" + serviceName));
            return;
        }
        MethodDescriptor methodDescriptor = null;
        List<MethodDescriptor> methodDescriptors = null;
        if ("$invoke".equals(methodName) || "$invokeAsync".equals(methodName)) {
            methodDescriptor = repo.lookupMethod(GenericService.class.getName(), methodName);
        } else if ("$echo".equals(methodName)) {
            methodDescriptor = repo.lookupMethod(EchoService.class.getName(), methodName);
        } else {
            methodDescriptors = serviceDescriptor.getMethods(methodName);
            if (methodDescriptors == null || methodDescriptors.isEmpty()) {
                TripleUtil.responseErr(ctx, GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED).withDescription("Method :" + methodName + " not found of service:" + serviceName));
                return;
            }
            if (methodDescriptors.size() == 1) {
                methodDescriptor = methodDescriptors.get(0);
            }
        }
        AbstractServerStream stream = methodDescriptor != null && methodDescriptor.isStream() ? AbstractServerStream.stream(invoker.getUrl()) : AbstractServerStream.unary(invoker.getUrl());
        stream.service(serviceDescriptor).invoker(invoker).methodName(methodName).subscribe(new ServerTransportObserver(ctx));
        if (methodDescriptor != null) {
            stream.method(methodDescriptor);
        } else {
            stream.methods(methodDescriptors);
        }
        TransportObserver observer = stream.asTransportObserver();
        observer.tryOnMetadata(new Http2HeaderMeta(headers), false);
        if (msg.isEndStream()) {
            observer.tryOnComplete();
        }
        ctx.channel().attr(TripleUtil.SERVER_STREAM_KEY).set((Object)stream);
    }
}

