/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.Stream;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;

public class ServerTransportObserver
implements TransportObserver {
    private final ChannelHandlerContext ctx;
    private boolean headerSent = false;

    public ServerTransportObserver(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void onMetadata(Metadata metadata, boolean endStream, Stream.OperationHandler handler) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(true);
        metadata.forEach(e -> headers.set((Object)((CharSequence)e.getKey()), (Object)((CharSequence)e.getValue())));
        if (!this.headerSent) {
            this.headerSent = true;
            headers.status((CharSequence)HttpResponseStatus.OK.codeAsText());
            headers.set((Object)"content-type", (Object)"application/grpc+proto");
            this.ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers, endStream));
        } else {
            this.ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers, endStream));
        }
    }

    @Override
    public void onData(byte[] data, boolean endStream, Stream.OperationHandler handler) {
        ByteBuf buf = this.ctx.alloc().buffer();
        buf.writeByte(0);
        buf.writeInt(data.length);
        buf.writeBytes(data);
        this.ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(buf, false));
    }

    @Override
    public void onComplete(Stream.OperationHandler handler) {
    }
}

