/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.protocol.tri.TripleRpcException;

public class GrpcStatus {
    public final Code code;
    public final Throwable cause;
    public final String description;

    public GrpcStatus(Code code, Throwable cause, String description) {
        this.code = code;
        this.cause = cause;
        this.description = description;
    }

    public static GrpcStatus fromCode(int code) {
        return GrpcStatus.fromCode(Code.fromCode(code));
    }

    public static GrpcStatus fromCode(Code code) {
        return new GrpcStatus(code, null, null);
    }

    public static byte toDubboStatus(Code code) {
        byte status;
        switch (code) {
            case OK: {
                status = 20;
                break;
            }
            case UNKNOWN: {
                status = 70;
                break;
            }
            case DEADLINE_EXCEEDED: {
                status = 31;
                break;
            }
            case RESOURCE_EXHAUSTED: {
                status = 100;
                break;
            }
            case UNIMPLEMENTED: {
                status = 60;
                break;
            }
            case INVALID_ARGUMENT: {
                status = 40;
                break;
            }
            case INTERNAL: {
                status = 80;
                break;
            }
            case UNAVAILABLE: 
            case DATA_LOSS: {
                status = 35;
                break;
            }
            default: {
                status = 90;
            }
        }
        return status;
    }

    public static String limitSizeTo4KB(String desc) {
        if (desc.length() < 4096) {
            return desc;
        }
        return desc.substring(0, 4086);
    }

    public static String fromMessage(String raw) {
        if (raw == null || raw.isEmpty()) {
            return "";
        }
        return QueryStringDecoder.decodeComponent((String)raw);
    }

    public GrpcStatus withCause(Throwable cause) {
        return new GrpcStatus(this.code, cause, this.description);
    }

    public GrpcStatus withDescription(String description) {
        return new GrpcStatus(this.code, this.cause, description);
    }

    public TripleRpcException asException() {
        return new TripleRpcException(this);
    }

    public String toMessage() {
        String msg;
        if (this.cause == null) {
            msg = this.description;
        } else {
            String placeHolder = this.description == null ? "" : this.description;
            msg = StringUtils.toString(placeHolder, this.cause);
        }
        if (msg == null) {
            return "";
        }
        String output = GrpcStatus.limitSizeTo4KB(msg);
        QueryStringEncoder encoder = new QueryStringEncoder("");
        encoder.addParam("", output);
        return encoder.toString().substring(2);
    }

    static enum Code {
        OK(0),
        CANCELLED(1),
        UNKNOWN(2),
        INVALID_ARGUMENT(3),
        DEADLINE_EXCEEDED(4),
        NOT_FOUND(5),
        ALREADY_EXISTS(6),
        PERMISSION_DENIED(7),
        RESOURCE_EXHAUSTED(8),
        FAILED_PRECONDITION(9),
        ABORTED(10),
        OUT_OF_RANGE(11),
        UNIMPLEMENTED(12),
        INTERNAL(13),
        UNAVAILABLE(14),
        DATA_LOSS(15);

        final int code;

        private Code(int code) {
            this.code = code;
        }

        public static boolean isOk(Integer status) {
            return status == Code.OK.code;
        }

        public static Code fromCode(int code) {
            for (Code value : Code.values()) {
                if (value.code != code) continue;
                return value;
            }
            throw new IllegalStateException("Can not find status for code: " + code);
        }
    }
}

