/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;

public class GrpcDataDecoder
extends ReplayingDecoder<GrpcDecodeState> {
    private static final int RESERVED_MASK = 254;
    private static final int COMPRESSED_FLAG_MASK = 1;
    private final int maxDataSize;
    private int len;
    private boolean compressedFlag;

    public GrpcDataDecoder(int maxDataSize) {
        super((Object)GrpcDecodeState.HEADER);
        this.maxDataSize = maxDataSize;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((GrpcDecodeState)((Object)this.state())) {
            case HEADER: {
                byte type = in.readByte();
                if ((type & 0xFE) != 0) {
                    throw GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription("gRPC frame header malformed: reserved bits not zero").asException();
                }
                boolean bl = this.compressedFlag = (type & 1) != 0;
                if (this.compressedFlag) {
                    throw GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription("Compression is not supported ").asException();
                }
                this.len = in.readInt();
                if (this.len < 0 || this.len > this.maxDataSize) {
                    throw GrpcStatus.fromCode(GrpcStatus.Code.RESOURCE_EXHAUSTED).withDescription(String.format("gRPC message exceeds maximum size %d: %d", this.maxDataSize, this.len)).asException();
                }
                this.checkpoint((Object)GrpcDecodeState.PAYLOAD);
            }
            case PAYLOAD: {
                byte[] dst = new byte[this.len];
                in.readBytes(dst);
                out.add(dst);
                this.checkpoint((Object)GrpcDecodeState.HEADER);
                break;
            }
            default: {
                throw new RuntimeException("Should not reach here");
            }
        }
    }

    static enum GrpcDecodeState {
        HEADER,
        PAYLOAD;

    }
}

