/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2PingFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class GracefulShutdown {
    static final long GRACEFUL_SHUTDOWN_PING = 40715087873L;
    private static final long GRACEFUL_SHUTDOWN_PING_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(10L);
    private final ChannelHandlerContext ctx;
    private final ChannelPromise originPromise;
    private final String goAwayMessage;
    private boolean pingAckedOrTimeout;
    private Future<?> pingFuture;

    public GracefulShutdown(ChannelHandlerContext ctx, String goAwayMessage, ChannelPromise originPromise) {
        this.ctx = ctx;
        this.goAwayMessage = goAwayMessage;
        this.originPromise = originPromise;
    }

    public void gracefulShutdown() {
        DefaultHttp2GoAwayFrame goAwayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR, ByteBufUtil.writeAscii((ByteBufAllocator)this.ctx.alloc(), (CharSequence)this.goAwayMessage));
        goAwayFrame.setExtraStreamIds(Integer.MAX_VALUE);
        this.ctx.write((Object)goAwayFrame);
        this.pingFuture = this.ctx.executor().schedule(() -> this.secondGoAwayAndClose(this.ctx), GRACEFUL_SHUTDOWN_PING_TIMEOUT_NANOS, TimeUnit.NANOSECONDS);
        DefaultHttp2PingFrame pingFrame = new DefaultHttp2PingFrame(40715087873L, false);
        this.ctx.write((Object)pingFrame);
    }

    void secondGoAwayAndClose(ChannelHandlerContext ctx) {
        if (this.pingAckedOrTimeout) {
            return;
        }
        this.pingAckedOrTimeout = true;
        this.pingFuture.cancel(false);
        try {
            DefaultHttp2GoAwayFrame goAwayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR, ByteBufUtil.writeAscii((ByteBufAllocator)this.ctx.alloc(), (CharSequence)this.goAwayMessage));
            ctx.write((Object)goAwayFrame);
            ctx.flush();
            ctx.close(this.originPromise);
        }
        catch (Exception e) {
            ctx.fireExceptionCaught((Throwable)e);
        }
    }
}

