/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceRepository;
import org.apache.dubbo.rpc.protocol.tri.AbstractStream;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.ServerStream;
import org.apache.dubbo.rpc.protocol.tri.Stream;
import org.apache.dubbo.rpc.protocol.tri.TripleUtil;
import org.apache.dubbo.rpc.protocol.tri.UnaryServerStream;
import org.apache.dubbo.triple.TripleWrapper;

public abstract class AbstractServerStream
extends AbstractStream
implements Stream {
    protected static final ExecutorRepository EXECUTOR_REPOSITORY = ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
    private final ProviderModel providerModel;
    private List<MethodDescriptor> methodDescriptors;
    private Invoker<?> invoker;

    protected AbstractServerStream(URL url) {
        this(url, AbstractServerStream.lookupProviderModel(url));
    }

    protected AbstractServerStream(URL url, ProviderModel providerModel) {
        this(url, AbstractServerStream.lookupExecutor(url, providerModel), providerModel);
    }

    protected AbstractServerStream(URL url, Executor executor, ProviderModel providerModel) {
        super(url, executor);
        this.providerModel = providerModel;
        this.serialize(this.getUrl().getParameter("serialization", "hessian2"));
    }

    private static Executor lookupExecutor(URL url, ProviderModel providerModel) {
        ExecutorService executor = null;
        if (providerModel != null) {
            executor = (ExecutorService)providerModel.getServiceMetadata().getAttribute("threadpool");
        }
        if (executor == null) {
            executor = EXECUTOR_REPOSITORY.getExecutor(url);
        }
        if (executor == null) {
            executor = EXECUTOR_REPOSITORY.createExecutorIfAbsent(url);
        }
        return executor;
    }

    public static AbstractServerStream unary(URL url) {
        return new UnaryServerStream(url);
    }

    public static AbstractServerStream stream(URL url) {
        return new ServerStream(url);
    }

    private static ProviderModel lookupProviderModel(URL url) {
        ServiceRepository repo = ApplicationModel.getServiceRepository();
        ProviderModel model = repo.lookupExportedService(url.getServiceKey());
        if (model != null) {
            ClassLoadUtil.switchContextLoader(model.getServiceInterfaceClass().getClassLoader());
        }
        return model;
    }

    public List<MethodDescriptor> getMethodDescriptors() {
        return this.methodDescriptors;
    }

    public AbstractServerStream methods(List<MethodDescriptor> methods) {
        this.methodDescriptors = methods;
        return this;
    }

    public Invoker<?> getInvoker() {
        return this.invoker;
    }

    public ProviderModel getProviderModel() {
        return this.providerModel;
    }

    protected RpcInvocation buildInvocation(Metadata metadata) {
        RpcInvocation inv = new RpcInvocation();
        inv.setServiceName(this.getServiceDescriptor().getServiceName());
        inv.setTargetServiceUniqueName(this.getUrl().getServiceKey());
        inv.setMethodName(this.getMethodDescriptor().getMethodName());
        inv.setParameterTypes(this.getMethodDescriptor().getParameterClasses());
        inv.setReturnTypes(this.getMethodDescriptor().getReturnTypes());
        Map<String, Object> attachments = this.parseMetadataToMap(metadata);
        attachments.remove("interface");
        attachments.remove("serialization");
        attachments.remove("te");
        attachments.remove("path");
        attachments.remove("content-type");
        attachments.remove("tri-service-group");
        attachments.remove("tri-service-version");
        attachments.remove("grpc-message");
        attachments.remove("grpc-status");
        attachments.remove("grpc-timeout");
        inv.setObjectAttachments(attachments);
        return inv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] deserializeRequest(byte[] data) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (this.getProviderModel() != null) {
                ClassLoadUtil.switchContextLoader(this.getProviderModel().getServiceInterfaceClass().getClassLoader());
            }
            if (this.getMethodDescriptor() == null || this.getMethodDescriptor().isNeedWrap()) {
                TripleWrapper.TripleRequestWrapper wrapper = TripleUtil.unpack(data, TripleWrapper.TripleRequestWrapper.class);
                if (!this.getSerializeType().equals(TripleUtil.convertHessianFromWrapper(wrapper.getSerializeType()))) {
                    this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.INVALID_ARGUMENT).withDescription("Received inconsistent serialization type from client, reject to deserialize! Expected:" + this.getSerializeType() + " Actual:" + TripleUtil.convertHessianFromWrapper(wrapper.getSerializeType())));
                    Object[] objectArray = null;
                    return objectArray;
                }
                if (this.getMethodDescriptor() == null) {
                    Object[] paramTypes = (String[])wrapper.getArgTypesList().toArray((Object[])new String[wrapper.getArgsCount()]);
                    for (MethodDescriptor descriptor : this.getMethodDescriptors()) {
                        if (!Arrays.equals(descriptor.getCompatibleParamSignatures(), paramTypes)) continue;
                        this.method(descriptor);
                        break;
                    }
                    if (this.getMethodDescriptor() == null) {
                        this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED).withDescription("Method :" + this.getMethodName() + "[" + Arrays.toString(paramTypes) + "] not found of service:" + this.getServiceDescriptor().getServiceName()));
                        Iterator<MethodDescriptor> iterator = null;
                        return iterator;
                    }
                }
                Object[] objectArray = TripleUtil.unwrapReq(this.getUrl(), wrapper, this.getMultipleSerialization());
                return objectArray;
            }
            Object[] objectArray = new Object[]{TripleUtil.unpack(data, this.getMethodDescriptor().getParameterClasses()[0])};
            return objectArray;
        }
        finally {
            ClassLoadUtil.switchContextLoader(tccl);
        }
    }

    protected byte[] encodeResponse(Object value) {
        Object message = this.getMethodDescriptor().isNeedWrap() ? TripleUtil.wrapResp(this.getUrl(), this.getSerializeType(), value, this.getMethodDescriptor(), this.getMultipleSerialization()) : (Message)value;
        return TripleUtil.pack(message);
    }

    @Override
    public void execute(Runnable runnable) {
        try {
            super.execute(runnable);
        }
        catch (RejectedExecutionException e) {
            LOGGER.error("Provider's thread pool is full", e);
            this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.RESOURCE_EXHAUSTED).withDescription("Provider's thread pool is full"));
        }
        catch (Throwable t) {
            LOGGER.error("Provider submit request to thread pool error ", t);
            this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withCause(t).withDescription("Provider's error"));
        }
    }

    public AbstractServerStream service(ServiceDescriptor sd) {
        this.setServiceDescriptor(sd);
        return this;
    }

    public AbstractServerStream invoker(Invoker<?> invoker) {
        this.invoker = invoker;
        return this;
    }
}

