/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.route;

import java.text.MessageFormat;
import java.util.Map;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshRuleRouter;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.VsDestinationGroup;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.destination.DestinationRule;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.VirtualServiceRule;
import org.apache.dubbo.rpc.cluster.router.mesh.util.VsDestinationGroupRuleDispatcher;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class MeshAppRuleListener
implements ConfigurationListener {
    public static final Logger logger = LoggerFactory.getLogger(MeshAppRuleListener.class);
    private final VsDestinationGroupRuleDispatcher vsDestinationGroupRuleDispatcher = new VsDestinationGroupRuleDispatcher();
    private final String appName;
    private volatile VsDestinationGroup vsDestinationGroupHolder;

    public MeshAppRuleListener(String appName) {
        this.appName = appName;
    }

    public void receiveConfigInfo(String configInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug(MessageFormat.format("[MeshAppRule] Received rule for app [{0}]: {1}.", this.appName, configInfo));
        }
        try {
            VsDestinationGroup vsDestinationGroup = new VsDestinationGroup();
            vsDestinationGroup.setAppName(this.appName);
            Representer representer = new Representer();
            representer.getPropertyUtils().setSkipMissingProperties(true);
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
            Iterable objectIterable = yaml.loadAll(configInfo);
            for (Object result : objectIterable) {
                Map resultMap = (Map)result;
                if ("DestinationRule".equals(resultMap.get("kind"))) {
                    DestinationRule destinationRule = PojoUtils.mapToPojo(resultMap, DestinationRule.class);
                    vsDestinationGroup.getDestinationRuleList().add(destinationRule);
                    continue;
                }
                if (!"VirtualService".equals(resultMap.get("kind"))) continue;
                VirtualServiceRule virtualServiceRule = PojoUtils.mapToPojo(resultMap, VirtualServiceRule.class);
                vsDestinationGroup.getVirtualServiceRuleList().add(virtualServiceRule);
            }
            this.vsDestinationGroupHolder = vsDestinationGroup;
        }
        catch (Exception e) {
            logger.error("[MeshAppRule] parse failed: " + configInfo, e);
        }
        if (this.vsDestinationGroupHolder != null) {
            this.vsDestinationGroupRuleDispatcher.post(this.vsDestinationGroupHolder);
        }
    }

    public void register(MeshRuleRouter subscriber) {
        if (this.vsDestinationGroupHolder != null) {
            subscriber.onRuleChange(this.vsDestinationGroupHolder);
        }
        this.vsDestinationGroupRuleDispatcher.register(subscriber);
    }

    public void unregister(MeshRuleRouter sub) {
        this.vsDestinationGroupRuleDispatcher.unregister(sub);
    }

    @Override
    public void process(ConfigChangedEvent event) {
        if (event.getChangeType() == ConfigChangeType.DELETED) {
            this.receiveConfigInfo("");
            return;
        }
        this.receiveConfigInfo(event.getContent());
    }
}

