/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.governance;

import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.rpc.cluster.governance.GovernanceRuleRepository;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DefaultGovernanceRuleRepositoryImpl
implements GovernanceRuleRepository {
    @Override
    public void addListener(String key, String group, ConfigurationListener listener) {
        DynamicConfiguration dynamicConfiguration = this.getDynamicConfiguration();
        if (dynamicConfiguration != null) {
            dynamicConfiguration.addListener(key, group, listener);
        }
    }

    @Override
    public void removeListener(String key, String group, ConfigurationListener listener) {
        DynamicConfiguration dynamicConfiguration = this.getDynamicConfiguration();
        if (dynamicConfiguration != null) {
            dynamicConfiguration.removeListener(key, group, listener);
        }
    }

    @Override
    public String getRule(String key, String group, long timeout) throws IllegalStateException {
        DynamicConfiguration dynamicConfiguration = this.getDynamicConfiguration();
        if (dynamicConfiguration != null) {
            return dynamicConfiguration.getConfig(key, group, timeout);
        }
        return null;
    }

    private DynamicConfiguration getDynamicConfiguration() {
        return ApplicationModel.getEnvironment().getDynamicConfiguration().orElse(null);
    }
}

