/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.remoting.api.NettyEventLoopFactory;
import org.apache.dubbo.remoting.api.PortUnificationServerHandler;
import org.apache.dubbo.remoting.api.SslServerTlsHandler;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.utils.UrlUtils;

public class PortUnificationServer {
    private static final Logger logger = LoggerFactory.getLogger(PortUnificationServer.class);
    private final List<WireProtocol> protocols;
    private final URL url;
    private ServerBootstrap bootstrap;
    private Channel channel;
    private DefaultChannelGroup channelGroup;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public PortUnificationServer(URL url) {
        this.url = ExecutorUtil.setThreadName(url, "DubboPUServerHandler");
        this.protocols = ExtensionLoader.getExtensionLoader(WireProtocol.class).getActivateExtension(url, new String[0]);
    }

    public URL getUrl() {
        return this.url;
    }

    public void bind() {
        if (this.channel == null) {
            this.doOpen();
        }
    }

    public void close() throws Throwable {
        if (this.channel != null) {
            this.doClose();
        }
    }

    protected void doOpen() {
        this.bootstrap = new ServerBootstrap();
        this.bossGroup = NettyEventLoopFactory.eventLoopGroup(1, "NettyServerBoss");
        this.workerGroup = NettyEventLoopFactory.eventLoopGroup(this.getUrl().getPositiveParameter("iothreads", Constants.DEFAULT_IO_THREADS), "NettyServerWorker");
        ((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NettyEventLoopFactory.serverSocketChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                int idleTimeout = UrlUtils.getIdleTimeout(PortUnificationServer.this.getUrl());
                ChannelPipeline p = ch.pipeline();
                boolean enableSsl = PortUnificationServer.this.getUrl().getParameter("ssl-enabled", false);
                if (enableSsl) {
                    p.addLast("negotiation-ssl", (ChannelHandler)new SslServerTlsHandler(PortUnificationServer.this.getUrl()));
                }
                PortUnificationServerHandler puHandler = new PortUnificationServerHandler(PortUnificationServer.this.protocols);
                p.addLast("server-idle-handler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)idleTimeout, TimeUnit.MILLISECONDS));
                p.addLast("negotiation-protocol", (ChannelHandler)puHandler);
                PortUnificationServer.this.channelGroup = puHandler.getChannels();
            }
        });
        String bindIp = this.getUrl().getParameter("bind.ip", this.getUrl().getHost());
        int bindPort = this.getUrl().getParameter("bind.port", this.getUrl().getPort());
        if (this.url.getParameter("anyhost", false) || NetUtils.isInvalidLocalHost(bindIp)) {
            bindIp = "0.0.0.0";
        }
        InetSocketAddress bindAddress = new InetSocketAddress(bindIp, bindPort);
        ChannelFuture channelFuture = this.bootstrap.bind((SocketAddress)bindAddress);
        channelFuture.syncUninterruptibly();
        this.channel = channelFuture.channel();
    }

    protected void doClose() throws Throwable {
        long st = System.currentTimeMillis();
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            if (this.channelGroup != null) {
                ChannelGroupFuture closeFuture = this.channelGroup.close();
                closeFuture.await(15000L);
            }
            long cost = System.currentTimeMillis() - st;
            logger.info("Port unification server closed. cost:" + cost);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while shutting down", e);
        }
        for (WireProtocol protocol : this.protocols) {
            protocol.close();
        }
        try {
            if (this.bootstrap != null) {
                this.bossGroup.shutdownGracefully().syncUninterruptibly();
                this.workerGroup.shutdownGracefully().syncUninterruptibly();
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public boolean isBound() {
        return this.channel.isActive();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }
}

