/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.zookeeper.util;

import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstanceBuilder;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.zookeeper.ZookeeperInstance;
import org.apache.dubbo.registry.zookeeper.util.CuratorFrameworkParams;

public abstract class CuratorFrameworkUtils {
    public static ServiceDiscovery<ZookeeperInstance> buildServiceDiscovery(CuratorFramework curatorFramework, String basePath) {
        return ServiceDiscoveryBuilder.builder(ZookeeperInstance.class).client(curatorFramework).basePath(basePath).build();
    }

    public static CuratorFramework buildCuratorFramework(URL connectionURL) throws Exception {
        CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(connectionURL.getBackupAddress()).retryPolicy(CuratorFrameworkUtils.buildRetryPolicy(connectionURL)).build();
        curatorFramework.start();
        curatorFramework.blockUntilConnected(((Integer)CuratorFrameworkParams.BLOCK_UNTIL_CONNECTED_WAIT.getParameterValue(connectionURL)).intValue(), (TimeUnit)((Object)CuratorFrameworkParams.BLOCK_UNTIL_CONNECTED_UNIT.getParameterValue(connectionURL)));
        return curatorFramework;
    }

    public static RetryPolicy buildRetryPolicy(URL connectionURL) {
        int baseSleepTimeMs = (Integer)CuratorFrameworkParams.BASE_SLEEP_TIME.getParameterValue(connectionURL);
        int maxRetries = (Integer)CuratorFrameworkParams.MAX_RETRIES.getParameterValue(connectionURL);
        int getMaxSleepMs = (Integer)CuratorFrameworkParams.MAX_SLEEP.getParameterValue(connectionURL);
        return new ExponentialBackoffRetry(baseSleepTimeMs, maxRetries, getMaxSleepMs);
    }

    public static List<ServiceInstance> build(Collection<org.apache.curator.x.discovery.ServiceInstance<ZookeeperInstance>> instances) {
        return instances.stream().map(CuratorFrameworkUtils::build).collect(Collectors.toList());
    }

    public static ServiceInstance build(org.apache.curator.x.discovery.ServiceInstance<ZookeeperInstance> instance) {
        String name = instance.getName();
        String host = instance.getAddress();
        int port = instance.getPort();
        ZookeeperInstance zookeeperInstance = (ZookeeperInstance)instance.getPayload();
        DefaultServiceInstance serviceInstance = new DefaultServiceInstance(name, host, port);
        serviceInstance.setMetadata(zookeeperInstance.getMetadata());
        return serviceInstance;
    }

    public static org.apache.curator.x.discovery.ServiceInstance<ZookeeperInstance> build(ServiceInstance serviceInstance) {
        ServiceInstanceBuilder builder = null;
        String serviceName = serviceInstance.getServiceName();
        String host = serviceInstance.getHost();
        int port = serviceInstance.getPort();
        SortedMap<String, String> metadata = serviceInstance.getSortedMetadata();
        String id = CuratorFrameworkUtils.generateId(host, port);
        ZookeeperInstance zookeeperInstance = new ZookeeperInstance(null, serviceName, metadata);
        try {
            builder = org.apache.curator.x.discovery.ServiceInstance.builder().id(id).name(serviceName).address(host).port(port).payload((Object)zookeeperInstance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return builder.build();
    }

    public static final String generateId(String host, int port) {
        return host + ":" + port;
    }
}

