/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.SelfHostMetaServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.xds.util.PilotExchanger;
import org.apache.dubbo.registry.xds.util.protocol.message.Endpoint;

public class XdsServiceDiscovery
extends SelfHostMetaServiceDiscovery {
    private PilotExchanger exchanger;
    private static final Logger logger = LoggerFactory.getLogger(XdsServiceDiscovery.class);

    @Override
    public void doInitialize(URL registryURL) throws Exception {
        try {
            this.exchanger = PilotExchanger.initialize(registryURL);
        }
        catch (Throwable t) {
            logger.error(t);
        }
    }

    @Override
    public void doDestroy() throws Exception {
        this.exchanger.destroy();
    }

    @Override
    public Set<String> getServices() {
        return this.exchanger.getServices();
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        Set<Endpoint> endpoints = this.exchanger.getEndpoints(serviceName);
        return this.changedToInstances(serviceName, endpoints);
    }

    @Override
    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        listener.getServiceNames().forEach(serviceName -> this.exchanger.observeEndpoints((String)serviceName, endpoints -> this.notifyListener((String)serviceName, listener, this.changedToInstances((String)serviceName, (Collection<Endpoint>)endpoints))));
    }

    private List<ServiceInstance> changedToInstances(String serviceName, Collection<Endpoint> endpoints) {
        LinkedList<ServiceInstance> instances = new LinkedList<ServiceInstance>();
        endpoints.forEach(endpoint -> {
            try {
                DefaultServiceInstance serviceInstance = new DefaultServiceInstance(serviceName, endpoint.getAddress(), endpoint.getPortValue());
                this.fillServiceInstance(serviceInstance);
                instances.add(serviceInstance);
            }
            catch (Throwable t) {
                logger.error("Error occurred when parsing endpoints. Endpoints List:" + endpoints, t);
            }
        });
        instances.sort(Comparator.comparingInt(ServiceInstance::hashCode));
        return instances;
    }
}

