/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Adaptive;
import org.apache.dubbo.common.extension.SPI;

@SPI
public interface XdsCertificateSigner {
    @Adaptive(value={"Signer"})
    public CertPair request(URL var1);

    public static class CertPair {
        private final String privateKey;
        private final String publicKey;
        private final long expireTime;

        public CertPair(String privateKey, String publicKey, long expireTime) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
            this.expireTime = expireTime;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public boolean isExpire() {
            return System.currentTimeMillis() < this.expireTime;
        }
    }
}

