/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.function.ThrowableConsumer;
import org.apache.dubbo.common.function.ThrowableFunction;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.nacos.NacosNamingServiceWrapper;
import org.apache.dubbo.registry.nacos.util.NacosNamingServiceUtils;

public class NacosServiceDiscovery
extends AbstractServiceDiscovery {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private NacosNamingServiceWrapper namingService;
    private URL registryURL;

    @Override
    public void doInitialize(URL registryURL) throws Exception {
        this.namingService = NacosNamingServiceUtils.createNamingService(registryURL);
        this.registryURL = registryURL;
    }

    @Override
    public void doDestroy() throws Exception {
        this.namingService.shutdown();
    }

    @Override
    public void doRegister(ServiceInstance serviceInstance) {
        ThrowableConsumer.execute(this.namingService, service -> {
            Instance instance = NacosNamingServiceUtils.toInstance(serviceInstance);
            service.registerInstance(instance.getServiceName(), "DEFAULT_GROUP", instance);
        });
    }

    @Override
    public void doUpdate(ServiceInstance serviceInstance) {
        ServiceInstance oldInstance = this.serviceInstance;
        this.unregister(oldInstance);
        this.register(serviceInstance);
    }

    @Override
    public void doUnregister(ServiceInstance serviceInstance) throws RuntimeException {
        ThrowableConsumer.execute(this.namingService, service -> {
            Instance instance = NacosNamingServiceUtils.toInstance(serviceInstance);
            service.deregisterInstance(instance.getServiceName(), "DEFAULT_GROUP", instance);
        });
    }

    @Override
    public Set<String> getServices() {
        return ThrowableFunction.execute(this.namingService, service -> {
            ListView<String> view = service.getServicesOfServer(0, Integer.MAX_VALUE, "DEFAULT_GROUP");
            return new LinkedHashSet(view.getData());
        });
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        return ThrowableFunction.execute(this.namingService, service -> service.selectInstances(serviceName, "DEFAULT_GROUP", true).stream().map(NacosNamingServiceUtils::toServiceInstance).collect(Collectors.toList()));
    }

    @Override
    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        ThrowableConsumer.execute(this.namingService, service -> listener.getServiceNames().forEach(serviceName -> {
            try {
                service.subscribe((String)serviceName, "DEFAULT_GROUP", e -> {
                    if (e instanceof NamingEvent) {
                        NamingEvent event = (NamingEvent)e;
                        this.handleEvent(event, listener);
                    }
                });
            }
            catch (NacosException e2) {
                this.logger.error("add nacos service instances changed listener fail ", e2);
            }
        }));
    }

    @Override
    public URL getUrl() {
        return this.registryURL;
    }

    private void handleEvent(NamingEvent event, ServiceInstancesChangedListener listener) {
        String serviceName = event.getServiceName();
        List<ServiceInstance> serviceInstances = event.getInstances().stream().map(NacosNamingServiceUtils::toServiceInstance).collect(Collectors.toList());
        listener.onEvent(new ServiceInstancesChangedEvent(serviceName, serviceInstances));
    }
}

