/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.kubernetes;

import com.alibaba.fastjson.JSONObject;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.kubernetes.KubernetesMeshEnvListener;
import org.apache.dubbo.registry.kubernetes.util.KubernetesConfigUtils;

public class KubernetesServiceDiscovery
extends AbstractServiceDiscovery {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private KubernetesClient kubernetesClient;
    private String currentHostname;
    private URL registryURL;
    private String namespace;
    private boolean enableRegister;
    public static final String KUBERNETES_PROPERTIES_KEY = "io.dubbo/metadata";
    private static final ConcurrentHashMap<String, Watch> SERVICE_WATCHER = new ConcurrentHashMap(64);
    private static final ConcurrentHashMap<String, Watch> PODS_WATCHER = new ConcurrentHashMap(64);
    private static final ConcurrentHashMap<String, Watch> ENDPOINTS_WATCHER = new ConcurrentHashMap(64);
    private static final ConcurrentHashMap<String, AtomicLong> SERVICE_UPDATE_TIME = new ConcurrentHashMap(64);

    @Override
    public void doInitialize(URL registryURL) throws Exception {
        boolean availableAccess;
        Config config = KubernetesConfigUtils.createKubernetesConfig(registryURL);
        this.kubernetesClient = new DefaultKubernetesClient(config);
        this.currentHostname = System.getenv("HOSTNAME");
        this.registryURL = registryURL;
        this.namespace = config.getNamespace();
        this.enableRegister = registryURL.getParameter("enableRegister", true);
        try {
            availableAccess = ((PodResource)this.kubernetesClient.pods().withName(this.currentHostname)).get() != null;
        }
        catch (Throwable e) {
            availableAccess = false;
        }
        if (!availableAccess) {
            String message = "Unable to access api server. Please check your url config. Master URL: " + config.getMasterUrl() + " Hostname: " + this.currentHostname;
            this.logger.error(message);
        } else {
            KubernetesMeshEnvListener.injectKubernetesEnv(this.kubernetesClient, this.namespace);
        }
    }

    @Override
    public void doDestroy() throws Exception {
        SERVICE_WATCHER.forEach((k, v) -> v.close());
        SERVICE_WATCHER.clear();
        PODS_WATCHER.forEach((k, v) -> v.close());
        PODS_WATCHER.clear();
        ENDPOINTS_WATCHER.forEach((k, v) -> v.close());
        ENDPOINTS_WATCHER.clear();
        this.kubernetesClient.close();
    }

    @Override
    public void doRegister(ServiceInstance serviceInstance) throws RuntimeException {
        if (this.enableRegister) {
            ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.namespace)).withName(this.currentHostname)).edit(pod -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(pod).editOrNewMetadata().addToAnnotations(KUBERNETES_PROPERTIES_KEY, JSONObject.toJSONString(serviceInstance.getMetadata()))).endMetadata()).build());
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Write Current Service Instance Metadata to Kubernetes pod. Current pod name: " + this.currentHostname);
            }
        }
    }

    @Override
    public void doUpdate(ServiceInstance serviceInstance) throws RuntimeException {
        this.register(serviceInstance);
    }

    @Override
    public void doUnregister(ServiceInstance serviceInstance) throws RuntimeException {
        if (this.enableRegister) {
            ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.namespace)).withName(this.currentHostname)).edit(pod -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(pod).editOrNewMetadata().removeFromAnnotations(KUBERNETES_PROPERTIES_KEY)).endMetadata()).build());
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Remove Current Service Instance from Kubernetes pod. Current pod name: " + this.currentHostname);
            }
        }
    }

    @Override
    public Set<String> getServices() {
        return ((ServiceList)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(this.namespace)).list()).getItems().stream().map(service -> service.getMetadata().getName()).collect(Collectors.toSet());
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        Endpoints endpoints = (Endpoints)((Resource)((NonNamespaceOperation)this.kubernetesClient.endpoints().inNamespace(this.namespace)).withName(serviceName)).get();
        return this.toServiceInstance(endpoints, serviceName);
    }

    @Override
    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        listener.getServiceNames().forEach(serviceName -> {
            SERVICE_UPDATE_TIME.put((String)serviceName, new AtomicLong(0L));
            this.watchEndpoints(listener, (String)serviceName);
            this.watchPods(listener, (String)serviceName);
            this.watchService(listener, (String)serviceName);
        });
    }

    private void watchEndpoints(final ServiceInstancesChangedListener listener, final String serviceName) {
        Watch watch = ((Resource)((NonNamespaceOperation)this.kubernetesClient.endpoints().inNamespace(this.namespace)).withName(serviceName)).watch((Object)new Watcher<Endpoints>(){

            public void eventReceived(Watcher.Action action, Endpoints resource) {
                if (KubernetesServiceDiscovery.this.logger.isDebugEnabled()) {
                    KubernetesServiceDiscovery.this.logger.debug("Received Endpoint Event. Event type: " + action.name() + ". Current pod name: " + KubernetesServiceDiscovery.this.currentHostname);
                }
                KubernetesServiceDiscovery.this.notifyServiceChanged(serviceName, listener);
            }

            public void onClose(WatcherException cause) {
            }
        });
        ENDPOINTS_WATCHER.put(serviceName, watch);
    }

    private void watchPods(final ServiceInstancesChangedListener listener, final String serviceName) {
        Map<String, String> serviceSelector = this.getServiceSelector(serviceName);
        if (serviceSelector == null) {
            return;
        }
        Watch watch = ((FilterWatchListDeletable)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.namespace)).withLabels(serviceSelector)).watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod resource) {
                if (Watcher.Action.MODIFIED.equals((Object)action)) {
                    if (KubernetesServiceDiscovery.this.logger.isDebugEnabled()) {
                        KubernetesServiceDiscovery.this.logger.debug("Received Pods Update Event. Current pod name: " + KubernetesServiceDiscovery.this.currentHostname);
                    }
                    KubernetesServiceDiscovery.this.notifyServiceChanged(serviceName, listener);
                }
            }

            public void onClose(WatcherException cause) {
            }
        });
        PODS_WATCHER.put(serviceName, watch);
    }

    private void watchService(final ServiceInstancesChangedListener listener, final String serviceName) {
        Watch watch = ((ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(this.namespace)).withName(serviceName)).watch((Object)new Watcher<Service>(){

            public void eventReceived(Watcher.Action action, Service resource) {
                if (Watcher.Action.MODIFIED.equals((Object)action)) {
                    if (KubernetesServiceDiscovery.this.logger.isDebugEnabled()) {
                        KubernetesServiceDiscovery.this.logger.debug("Received Service Update Event. Update Pods Watcher. Current pod name: " + KubernetesServiceDiscovery.this.currentHostname);
                    }
                    if (PODS_WATCHER.containsKey(serviceName)) {
                        ((Watch)PODS_WATCHER.get(serviceName)).close();
                        PODS_WATCHER.remove(serviceName);
                    }
                    KubernetesServiceDiscovery.this.watchPods(listener, serviceName);
                }
            }

            public void onClose(WatcherException cause) {
            }
        });
        SERVICE_WATCHER.put(serviceName, watch);
    }

    private void notifyServiceChanged(String serviceName, ServiceInstancesChangedListener listener) {
        long receivedTime = System.nanoTime();
        ServiceInstancesChangedEvent event = new ServiceInstancesChangedEvent(serviceName, this.getInstances(serviceName));
        AtomicLong updateTime = SERVICE_UPDATE_TIME.get(serviceName);
        long lastUpdateTime = updateTime.get();
        if (lastUpdateTime <= receivedTime && updateTime.compareAndSet(lastUpdateTime, receivedTime)) {
            listener.onEvent(event);
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Discard Service Instance Data. Possible Cause: Newer message has been processed or Failed to update time record by CAS. Current Data received time: " + receivedTime + ". Newer Data received time: " + lastUpdateTime + ".");
        }
    }

    @Override
    public URL getUrl() {
        return this.registryURL;
    }

    private Map<String, String> getServiceSelector(String serviceName) {
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(this.namespace)).withName(serviceName)).get();
        if (service == null) {
            return null;
        }
        return service.getSpec().getSelector();
    }

    private List<ServiceInstance> toServiceInstance(Endpoints endpoints, String serviceName) {
        Map<String, String> serviceSelector = this.getServiceSelector(serviceName);
        if (serviceSelector == null) {
            return new LinkedList<ServiceInstance>();
        }
        Map<String, Pod> pods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.namespace)).withLabels(serviceSelector)).list()).getItems().stream().collect(Collectors.toMap(pod -> pod.getMetadata().getName(), pod -> pod));
        LinkedList<ServiceInstance> instances = new LinkedList<ServiceInstance>();
        HashSet instancePorts = new HashSet();
        for (EndpointSubset endpointSubset : endpoints.getSubsets()) {
            instancePorts.addAll(endpointSubset.getPorts().stream().map(EndpointPort::getPort).collect(Collectors.toSet()));
        }
        for (EndpointSubset endpointSubset : endpoints.getSubsets()) {
            for (EndpointAddress address : endpointSubset.getAddresses()) {
                Pod pod2 = pods.get(address.getTargetRef().getName());
                String ip = address.getIp();
                if (pod2 == null) {
                    this.logger.warn("Unable to match Kubernetes Endpoint address with Pod. EndpointAddress Hostname: " + address.getTargetRef().getName());
                    continue;
                }
                instancePorts.forEach(port -> {
                    DefaultServiceInstance serviceInstance = new DefaultServiceInstance(serviceName, ip, (Integer)port);
                    String properties = (String)pod2.getMetadata().getAnnotations().get(KUBERNETES_PROPERTIES_KEY);
                    if (StringUtils.isNotEmpty(properties)) {
                        serviceInstance.getMetadata().putAll((Map)JSONObject.parseObject((String)properties, Map.class));
                        instances.add(serviceInstance);
                    } else {
                        this.logger.warn("Unable to find Service Instance metadata in Pod Annotations. Possibly cause: provider has not been initialized successfully. EndpointAddress Hostname: " + address.getTargetRef().getName());
                    }
                });
            }
        }
        return instances;
    }

    @Deprecated
    public void setCurrentHostname(String currentHostname) {
        this.currentHostname = currentHostname;
    }

    @Deprecated
    public void setKubernetesClient(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }
}

