/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.dns.util;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.concurrent.Future;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.dns.util.ResolveResult;

public class DNSResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DnsNameResolver resolver;
    private static final EventLoopGroup GROUP = new NioEventLoopGroup(1);

    public DNSResolver(String nameserver, int port, int maxQueriesPerResolve) {
        this.resolver = DNSResolver.newResolver(nameserver, port, maxQueriesPerResolve);
    }

    public ResolveResult resolve(String path) {
        ResolveResult recordList = new ResolveResult();
        try {
            Future hostFuture = this.resolver.resolveAll(path);
            Future srvFuture = this.resolver.query((DnsQuestion)new DefaultDnsQuestion(path, DnsRecordType.SRV));
            try {
                recordList.getHostnameList().addAll(((List)hostFuture.sync().getNow()).stream().map(InetAddress::getHostAddress).collect(Collectors.toList()));
                DnsResponse srvResponse = (DnsResponse)((AddressedEnvelope)srvFuture.sync().getNow()).content();
                for (int i = 0; i < srvResponse.count(DnsSection.ANSWER); ++i) {
                    DnsRawRecord record = (DnsRawRecord)srvResponse.recordAt(DnsSection.ANSWER, i);
                    ByteBuf buf = record.content();
                    buf.readUnsignedShort();
                    buf.readUnsignedShort();
                    int port = buf.readUnsignedShort();
                    recordList.getPort().add(port);
                }
            }
            catch (InterruptedException e) {
                this.logger.warn("Waiting DNS resolve interrupted. " + e.getLocalizedMessage());
            }
        }
        catch (Throwable t) {
            if (t instanceof UnknownHostException) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(t.getLocalizedMessage());
                }
            }
            this.logger.error(t.getLocalizedMessage());
        }
        return recordList;
    }

    public void destroy() {
        this.resolver.close();
    }

    private static DnsNameResolver newResolver(String nameserver, int port, int maxQueriesPerResolve) {
        return new DnsNameResolverBuilder(GROUP.next()).channelType(NioDatagramChannel.class).maxQueriesPerResolve(maxQueriesPerResolve).decodeIdn(true).optResourceEnabled(false).ndots(1).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).ttl(0, 1).nameServerProvider(hostname -> DnsServerAddresses.sequential((InetSocketAddress[])new InetSocketAddress[]{new InetSocketAddress(nameserver, port)}).stream()).build();
    }
}

