/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.registry.client.migration.model.MigrationStep;
import org.apache.dubbo.registry.client.migration.model.SubMigrationRule;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class MigrationRule {
    public static final MigrationRule INIT = new MigrationRule();
    private String key;
    private MigrationStep step;
    private Float threshold;
    private Integer proportion;
    private Integer delay;
    private Boolean force;
    private List<SubMigrationRule> interfaces;
    private List<SubMigrationRule> applications;
    private transient Map<String, SubMigrationRule> interfaceRules;
    private transient Map<String, SubMigrationRule> applicationRules;

    private static MigrationRule parseFromMap(Map<String, Object> map) {
        Object applications;
        Object interfaces;
        Object force;
        Object delay;
        Object proportion;
        Object threshold;
        MigrationRule migrationRule = new MigrationRule();
        migrationRule.setKey((String)map.get("key"));
        Object step = map.get("step");
        if (step != null) {
            migrationRule.setStep(MigrationStep.valueOf(step.toString()));
        }
        if ((threshold = map.get("threshold")) != null) {
            migrationRule.setThreshold(Float.valueOf(threshold.toString()));
        }
        if ((proportion = map.get("proportion")) != null) {
            migrationRule.setProportion(Integer.valueOf(proportion.toString()));
        }
        if ((delay = map.get("delay")) != null) {
            migrationRule.setDelay(Integer.valueOf(delay.toString()));
        }
        if ((force = map.get("force")) != null) {
            migrationRule.setForce(Boolean.valueOf(force.toString()));
        }
        if ((interfaces = map.get("interfaces")) != null && List.class.isAssignableFrom(interfaces.getClass())) {
            migrationRule.setInterfaces(((List)interfaces).stream().map(SubMigrationRule::parseFromMap).collect(Collectors.toList()));
        }
        if ((applications = map.get("applications")) != null && List.class.isAssignableFrom(applications.getClass())) {
            migrationRule.setApplications(((List)applications).stream().map(SubMigrationRule::parseFromMap).collect(Collectors.toList()));
        }
        return migrationRule;
    }

    public MigrationRule() {
    }

    public MigrationRule(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public MigrationStep getStep(URL consumerURL) {
        ServiceNameMapping serviceNameMapping;
        Set<String> services;
        SubMigrationRule rule;
        if (this.interfaceRules != null && (rule = this.interfaceRules.get(consumerURL.getDisplayServiceKey())) != null && rule.getStep() != null) {
            return rule.getStep();
        }
        if (this.applications != null && CollectionUtils.isNotEmpty(services = (serviceNameMapping = ServiceNameMapping.getDefaultExtension()).getServices(consumerURL))) {
            for (String service : services) {
                SubMigrationRule rule2 = this.applicationRules.get(service);
                if (rule2.getStep() == null) continue;
                return rule2.getStep();
            }
        }
        if (this.step == null) {
            this.step = MigrationStep.APPLICATION_FIRST;
            this.step = Enum.valueOf(MigrationStep.class, consumerURL.getParameter("migration.step", ConfigurationUtils.getCachedDynamicProperty("dubbo.application.service-discovery.migration", this.step.name())));
        }
        return this.step;
    }

    public MigrationStep getStep() {
        return this.step;
    }

    public float getThreshold(URL consumerURL) {
        ServiceNameMapping serviceNameMapping;
        Set<String> services;
        SubMigrationRule rule;
        if (this.interfaceRules != null && (rule = this.interfaceRules.get(consumerURL.getDisplayServiceKey())) != null && rule.getThreshold() != null) {
            return rule.getThreshold().floatValue();
        }
        if (this.applications != null && CollectionUtils.isNotEmpty(services = (serviceNameMapping = ServiceNameMapping.getDefaultExtension()).getServices(consumerURL))) {
            for (String service : services) {
                SubMigrationRule rule2 = this.applicationRules.get(service);
                if (rule2 == null || rule2.getThreshold() == null) continue;
                return rule2.getThreshold().floatValue();
            }
        }
        return this.threshold == null ? consumerURL.getParameter("migration.threshold", -1.0f) : this.threshold.floatValue();
    }

    public Float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Float threshold) {
        this.threshold = threshold;
    }

    public Integer getProportion() {
        return this.proportion;
    }

    public int getProportion(URL consumerURL) {
        ServiceNameMapping serviceNameMapping;
        Set<String> services;
        SubMigrationRule rule;
        if (this.interfaceRules != null && (rule = this.interfaceRules.get(consumerURL.getDisplayServiceKey())) != null && rule.getProportion() != null) {
            return rule.getProportion();
        }
        if (this.applications != null && CollectionUtils.isNotEmpty(services = (serviceNameMapping = ServiceNameMapping.getDefaultExtension()).getServices(consumerURL))) {
            for (String service : services) {
                SubMigrationRule rule2 = this.applicationRules.get(service);
                if (rule2 == null || rule2.getProportion() == null) continue;
                return rule2.getProportion();
            }
        }
        return this.proportion == null ? consumerURL.getParameter("migration.promotion", 100) : this.proportion.intValue();
    }

    public void setProportion(Integer proportion) {
        this.proportion = proportion;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public int getDelay(URL consumerURL) {
        ServiceNameMapping serviceNameMapping;
        Set<String> services;
        SubMigrationRule rule;
        if (this.interfaceRules != null && (rule = this.interfaceRules.get(consumerURL.getDisplayServiceKey())) != null && rule.getDelay() != null) {
            return rule.getDelay();
        }
        if (this.applications != null && CollectionUtils.isNotEmpty(services = (serviceNameMapping = ServiceNameMapping.getDefaultExtension()).getServices(consumerURL))) {
            for (String service : services) {
                SubMigrationRule rule2 = this.applicationRules.get(service);
                if (rule2 == null || rule2.getDelay() == null) continue;
                return rule2.getDelay();
            }
        }
        return this.delay == null ? consumerURL.getParameter("migration.delay", 0) : this.delay.intValue();
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public void setStep(MigrationStep step) {
        this.step = step;
    }

    public Boolean getForce() {
        return this.force;
    }

    public boolean getForce(URL consumerURL) {
        ServiceNameMapping serviceNameMapping;
        Set<String> services;
        SubMigrationRule rule;
        if (this.interfaceRules != null && (rule = this.interfaceRules.get(consumerURL.getDisplayServiceKey())) != null && rule.getForce() != null) {
            return rule.getForce();
        }
        if (this.applications != null && CollectionUtils.isNotEmpty(services = (serviceNameMapping = ServiceNameMapping.getDefaultExtension()).getServices(consumerURL))) {
            for (String service : services) {
                SubMigrationRule rule2 = this.applicationRules.get(service);
                if (rule2 == null || rule2.getForce() == null) continue;
                return rule2.getForce();
            }
        }
        return this.force == null ? consumerURL.getParameter("migration.force", false) : this.force.booleanValue();
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public List<SubMigrationRule> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<SubMigrationRule> interfaces) {
        this.interfaces = interfaces;
        if (interfaces != null) {
            this.interfaceRules = new HashMap<String, SubMigrationRule>();
            interfaces.forEach(rule -> this.interfaceRules.put(rule.getServiceKey(), (SubMigrationRule)rule));
        }
    }

    public List<SubMigrationRule> getApplications() {
        return this.applications;
    }

    public void setApplications(List<SubMigrationRule> applications) {
        this.applications = applications;
        if (applications != null) {
            this.applicationRules = new HashMap<String, SubMigrationRule>();
            applications.forEach(rule -> this.applicationRules.put(rule.getServiceKey(), (SubMigrationRule)rule));
        }
    }

    public static MigrationRule parse(String rawRule) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Map map = (Map)yaml.load(rawRule);
        return MigrationRule.parseFromMap(map);
    }

    public static String toYaml(MigrationRule rule) {
        Constructor constructor = new Constructor(MigrationRule.class);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        return yaml.dump((Object)rule);
    }
}

