/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.common.url.component.URLParam;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.client.InstanceAddressURL;
import org.apache.dubbo.registry.client.ServiceInstance;

public class OverrideInstanceAddressURL
extends InstanceAddressURL {
    private static final long serialVersionUID = 1373220432794558426L;
    private final URLParam overrideParams;
    private final InstanceAddressURL originUrl;
    private final transient Map<String, Map<String, Map<String, Number>>> methodNumberCache = new ConcurrentHashMap<String, Map<String, Map<String, Number>>>();
    private volatile transient Map<String, Map<String, Number>> methodNumbers;
    private final transient Map<String, Map<String, Number>> serviceNumberCache = new ConcurrentHashMap<String, Map<String, Number>>();
    private volatile transient Map<String, Number> numbers;

    public OverrideInstanceAddressURL(InstanceAddressURL originUrl) {
        this.originUrl = originUrl;
        this.overrideParams = URLParam.parse("");
    }

    public OverrideInstanceAddressURL(InstanceAddressURL originUrl, URLParam overrideParams) {
        this.originUrl = originUrl;
        this.overrideParams = overrideParams;
    }

    @Override
    public ServiceInstance getInstance() {
        return this.originUrl.getInstance();
    }

    @Override
    public MetadataInfo getMetadataInfo() {
        return this.originUrl.getMetadataInfo();
    }

    @Override
    public String getServiceInterface() {
        return this.originUrl.getServiceInterface();
    }

    @Override
    public String getGroup() {
        return this.originUrl.getGroup();
    }

    @Override
    public String getVersion() {
        return this.originUrl.getVersion();
    }

    @Override
    public String getProtocol() {
        return this.originUrl.getProtocol();
    }

    @Override
    public String getProtocolServiceKey() {
        return this.originUrl.getProtocolServiceKey();
    }

    @Override
    public String getServiceKey() {
        return this.originUrl.getServiceKey();
    }

    @Override
    public String getAddress() {
        return this.originUrl.getAddress();
    }

    @Override
    public String getHost() {
        return this.originUrl.getHost();
    }

    @Override
    public int getPort() {
        return this.originUrl.getPort();
    }

    @Override
    public String getIp() {
        return this.originUrl.getIp();
    }

    @Override
    public String getPath() {
        return this.originUrl.getPath();
    }

    @Override
    public String getParameter(String key) {
        String overrideParam = this.overrideParams.getParameter(key);
        return StringUtils.isNotEmpty(overrideParam) ? overrideParam : this.originUrl.getParameter(key);
    }

    @Override
    public String getServiceParameter(String service, String key) {
        String overrideParam = this.overrideParams.getParameter(key);
        return StringUtils.isNotEmpty(overrideParam) ? overrideParam : this.originUrl.getServiceParameter(service, key);
    }

    @Override
    public String getServiceMethodParameter(String protocolServiceKey, String method, String key) {
        String overrideParam = this.overrideParams.getMethodParameter(method, key);
        return StringUtils.isNotEmpty(overrideParam) ? overrideParam : this.originUrl.getServiceMethodParameter(protocolServiceKey, method, key);
    }

    @Override
    public String getMethodParameter(String method, String key) {
        String overrideParam = this.overrideParams.getMethodParameter(method, key);
        return StringUtils.isNotEmpty(overrideParam) ? overrideParam : this.originUrl.getMethodParameter(method, key);
    }

    @Override
    public boolean hasServiceMethodParameter(String protocolServiceKey, String method, String key) {
        return StringUtils.isNotEmpty(this.overrideParams.getMethodParameter(method, key)) || this.originUrl.hasServiceMethodParameter(protocolServiceKey, method, key);
    }

    @Override
    public boolean hasMethodParameter(String method, String key) {
        return StringUtils.isNotEmpty(this.overrideParams.getMethodParameter(method, key)) || this.originUrl.hasMethodParameter(method, key);
    }

    @Override
    public boolean hasServiceMethodParameter(String protocolServiceKey, String method) {
        return this.overrideParams.hasMethodParameter(method) || this.originUrl.hasServiceMethodParameter(protocolServiceKey, method);
    }

    @Override
    public boolean hasMethodParameter(String method) {
        return this.overrideParams.hasMethodParameter(method) || this.originUrl.hasMethodParameter(method);
    }

    @Override
    public Map<String, String> getServiceParameters(String protocolServiceKey) {
        Map<String, String> parameters = this.originUrl.getServiceParameters(protocolServiceKey);
        Map<String, String> overrideParameters = this.overrideParams.getParameters();
        HashMap<String, String> result = new HashMap<String, String>((int)((float)parameters.size() + (float)overrideParameters.size() / 0.75f) + 1);
        result.putAll(parameters);
        result.putAll(overrideParameters);
        return result;
    }

    @Override
    public Map<String, String> getParameters() {
        Map<String, String> parameters = this.originUrl.getParameters();
        Map<String, String> overrideParameters = this.overrideParams.getParameters();
        HashMap<String, String> result = new HashMap<String, String>((int)((float)parameters.size() + (float)overrideParameters.size() / 0.75f) + 1);
        result.putAll(parameters);
        result.putAll(overrideParameters);
        return result;
    }

    @Override
    public URL addParameter(String key, String value) {
        return new OverrideInstanceAddressURL(this.originUrl, this.overrideParams.addParameter(key, value));
    }

    @Override
    public URL addParameterIfAbsent(String key, String value) {
        return new OverrideInstanceAddressURL(this.originUrl, this.overrideParams.addParameterIfAbsent(key, value));
    }

    @Override
    public URL addServiceParameter(String protocolServiceKey, String key, String value) {
        return this.originUrl.addServiceParameter(protocolServiceKey, key, value);
    }

    @Override
    public URL addServiceParameterIfAbsent(String protocolServiceKey, String key, String value) {
        return this.originUrl.addServiceParameterIfAbsent(protocolServiceKey, key, value);
    }

    @Override
    public URL addConsumerParams(String protocolServiceKey, Map<String, String> params) {
        return this.originUrl.addConsumerParams(protocolServiceKey, params);
    }

    @Override
    public String getAnyMethodParameter(String key) {
        String overrideParam = this.overrideParams.getAnyMethodParameter(key);
        return StringUtils.isNotEmpty(overrideParam) ? overrideParam : this.originUrl.getAnyMethodParameter(key);
    }

    @Override
    public URL addParameters(Map<String, String> parameters) {
        return new OverrideInstanceAddressURL(this.originUrl, this.overrideParams.addParameters(parameters));
    }

    @Override
    public URL addParametersIfAbsent(Map<String, String> parameters) {
        return new OverrideInstanceAddressURL(this.originUrl, this.overrideParams.addParametersIfAbsent(parameters));
    }

    @Override
    public URLParam getUrlParam() {
        return this.originUrl.getUrlParam();
    }

    @Override
    public URLAddress getUrlAddress() {
        return this.originUrl.getUrlAddress();
    }

    @Override
    protected Map<String, Number> getServiceNumbers(String protocolServiceKey) {
        return this.serviceNumberCache.computeIfAbsent(protocolServiceKey, k -> new ConcurrentHashMap());
    }

    @Override
    protected Map<String, Number> getNumbers() {
        if (this.numbers == null) {
            this.numbers = new ConcurrentHashMap<String, Number>();
        }
        return this.numbers;
    }

    @Override
    protected Map<String, Map<String, Number>> getServiceMethodNumbers(String protocolServiceKey) {
        return this.methodNumberCache.computeIfAbsent(protocolServiceKey, k -> new ConcurrentHashMap());
    }

    @Override
    protected Map<String, Map<String, Number>> getMethodNumbers() {
        if (this.methodNumbers == null) {
            this.methodNumbers = new ConcurrentHashMap<String, Map<String, Number>>();
        }
        return this.methodNumbers;
    }

    public URLParam getOverrideParams() {
        return this.overrideParams;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OverrideInstanceAddressURL that = (OverrideInstanceAddressURL)o;
        return Objects.equals(this.overrideParams, that.overrideParams) && Objects.equals(this.originUrl, that.originUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.overrideParams, this.originUrl);
    }

    @Override
    public String toString() {
        return this.originUrl.toString() + ", overrideParams: " + this.overrideParams.toString();
    }

    protected OverrideInstanceAddressURL newURL(URLAddress urlAddress, URLParam urlParam) {
        return new OverrideInstanceAddressURL(this.originUrl, this.overrideParams);
    }
}

