/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;

public abstract class RegistryNotifier {
    private volatile long lastExecuteTime;
    private volatile long lastEventTime;
    private Object rawAddresses;
    private long delayTime;
    private final AtomicBoolean shouldDelay = new AtomicBoolean(false);
    private final AtomicInteger executeTime = new AtomicInteger(0);
    private ScheduledExecutorService scheduler;

    public RegistryNotifier(long delayTime) {
        this(delayTime, null);
    }

    public RegistryNotifier(long delayTime, ScheduledExecutorService scheduler) {
        this.delayTime = delayTime;
        this.scheduler = scheduler == null ? ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension().getRegistryNotificationExecutor() : scheduler;
    }

    public synchronized void notify(Object rawAddresses) {
        boolean delay;
        long notifyTime;
        this.rawAddresses = rawAddresses;
        this.lastEventTime = notifyTime = System.currentTimeMillis();
        long delta = System.currentTimeMillis() - this.lastExecuteTime - this.delayTime;
        boolean bl = delay = this.shouldDelay.get() && delta < 0L;
        if (delay) {
            this.scheduler.schedule(new NotificationTask(this, notifyTime), -delta, TimeUnit.MILLISECONDS);
        } else {
            if (!this.shouldDelay.get() && this.executeTime.incrementAndGet() > 10) {
                this.shouldDelay.set(true);
            }
            this.scheduler.submit(new NotificationTask(this, notifyTime));
        }
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    protected abstract void doNotify(Object var1);

    public static class NotificationTask
    implements Runnable {
        private final RegistryNotifier listener;
        private final long time;

        public NotificationTask(RegistryNotifier listener, long time) {
            this.listener = listener;
            this.time = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.time == this.listener.lastEventTime) {
                this.listener.doNotify(this.listener.rawAddresses);
                this.listener.lastExecuteTime = System.currentTimeMillis();
                RegistryNotifier registryNotifier = this.listener;
                synchronized (registryNotifier) {
                    if (this.time == this.listener.lastEventTime) {
                        this.listener.rawAddresses = null;
                    }
                }
            }
        }
    }
}

