/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.qos.probe.LivenessProbe;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Cmd(name="live", summary="Judge if service is alive? ")
public class Live
implements BaseCommand {
    @Override
    public String execute(CommandContext commandContext, String[] args) {
        URL url = URL.valueOf("application://").addParameter("dubbo.application.liveness-probe", ApplicationModel.getApplicationConfig().getLivenessProbe());
        List<LivenessProbe> livenessProbes = ExtensionLoader.getExtensionLoader(LivenessProbe.class).getActivateExtension(url, "dubbo.application.liveness-probe");
        if (!livenessProbes.isEmpty()) {
            for (LivenessProbe livenessProbe : livenessProbes) {
                if (livenessProbe.check()) continue;
                commandContext.setHttpCode(503);
                return "false";
            }
        }
        commandContext.setHttpCode(200);
        return "true";
    }
}

