/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.qos.command.util.CommandHelper;
import org.apache.dubbo.qos.textui.TTable;

@Cmd(name="help", summary="help command", example={"help", "help online"})
public class Help
implements BaseCommand {
    @Override
    public String execute(CommandContext commandContext, String[] args) {
        if (args != null && args.length > 0) {
            return this.commandHelp(args[0]);
        }
        return this.mainHelp();
    }

    private String commandHelp(String commandName) {
        if (!CommandHelper.hasCommand(commandName)) {
            return "no such command:" + commandName;
        }
        Class<?> clazz = CommandHelper.getCommandClass(commandName);
        Cmd cmd = clazz.getAnnotation(Cmd.class);
        TTable tTable = new TTable(new TTable.ColumnDefine[]{new TTable.ColumnDefine(TTable.Align.RIGHT), new TTable.ColumnDefine(80, false, TTable.Align.LEFT)});
        tTable.addRow("COMMAND NAME", commandName);
        if (null != cmd.example()) {
            tTable.addRow("EXAMPLE", this.drawExample(cmd));
        }
        return tTable.padding(1).rendering();
    }

    private String drawExample(Cmd cmd) {
        StringBuilder drawExampleStringBuilder = new StringBuilder();
        for (String example : cmd.example()) {
            drawExampleStringBuilder.append(example).append('\n');
        }
        return drawExampleStringBuilder.toString();
    }

    private String mainHelp() {
        TTable tTable = new TTable(new TTable.ColumnDefine[]{new TTable.ColumnDefine(TTable.Align.RIGHT), new TTable.ColumnDefine(80, false, TTable.Align.LEFT)});
        List<Class<?>> classes = CommandHelper.getAllCommandClass();
        Collections.sort(classes, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                Integer o1s = o1.getAnnotation(Cmd.class).sort();
                Integer o2s = o2.getAnnotation(Cmd.class).sort();
                return o1s.compareTo(o2s);
            }
        });
        for (Class<?> clazz : classes) {
            if (!clazz.isAnnotationPresent(Cmd.class)) continue;
            Cmd cmd = clazz.getAnnotation(Cmd.class);
            tTable.addRow(cmd.name(), cmd.summary());
        }
        return tTable.padding(1).rendering();
    }
}

