/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MappingListener;

@SPI(value="metadata")
public interface ServiceNameMapping {
    public static final String DEFAULT_MAPPING_GROUP = "mapping";

    public void map(URL var1);

    public static ServiceNameMapping getDefaultExtension() {
        return ExtensionLoader.getExtensionLoader(ServiceNameMapping.class).getDefaultExtension();
    }

    public static String buildMappingKey(URL url) {
        return ServiceNameMapping.buildGroup(url.getServiceInterface());
    }

    public static String buildGroup(String serviceInterface) {
        return DEFAULT_MAPPING_GROUP + StringUtils.SLASH + serviceInterface;
    }

    public static String toStringKeys(Set<String> serviceNames) {
        return serviceNames.toString();
    }

    public static Set<String> getAppNames(String content) {
        if (StringUtils.isBlank(content)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(content.split(",")));
    }

    public Set<String> getServices(URL var1);

    public Set<String> getAndListenServices(URL var1, URL var2, MappingListener var3);
}

