/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.DubboShutdownHook;
import org.apache.dubbo.config.bootstrap.BootstrapTakeoverMode;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.apache.dubbo.config.spring.context.DubboBootstrapStartStopListenerSpringAdapter;
import org.apache.dubbo.config.spring.context.DubboConfigBeanInitializer;
import org.apache.dubbo.config.spring.context.event.DubboAnnotationInitedEvent;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.util.ObjectUtils;

public class DubboBootstrapApplicationListener
implements ApplicationListener,
ApplicationContextAware,
Ordered {
    public static final String BEAN_NAME = "dubboBootstrapApplicationListener";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final DubboBootstrap dubboBootstrap = this.initBootstrap();
    private ApplicationContext applicationContext;

    private DubboBootstrap initBootstrap() {
        DubboBootstrap dubboBootstrap = DubboBootstrap.getInstance();
        if (dubboBootstrap.getTakeoverMode() != BootstrapTakeoverMode.MANUAL) {
            dubboBootstrap.setTakeoverMode(BootstrapTakeoverMode.SPRING);
        }
        return dubboBootstrap;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.isOriginalEventSource(event)) {
            if (event instanceof DubboAnnotationInitedEvent) {
                this.initDubboConfigBeans();
            } else if (event instanceof ApplicationContextEvent) {
                this.onApplicationContextEvent((ApplicationContextEvent)event);
            }
        }
    }

    private void initDubboConfigBeans() {
        if (this.applicationContext.containsBean(DubboConfigBeanInitializer.BEAN_NAME)) {
            this.applicationContext.getBean(DubboConfigBeanInitializer.BEAN_NAME, DubboConfigBeanInitializer.class);
        } else {
            this.logger.warn((Object)("Bean '" + DubboConfigBeanInitializer.BEAN_NAME + "' was not found"));
        }
        DubboBootstrap.getInstance().initialize();
    }

    private void onApplicationContextEvent(ApplicationContextEvent event) {
        if (DubboBootstrapStartStopListenerSpringAdapter.applicationContext == null) {
            DubboBootstrapStartStopListenerSpringAdapter.applicationContext = event.getApplicationContext();
        }
        if (event instanceof ContextRefreshedEvent) {
            this.onContextRefreshedEvent((ContextRefreshedEvent)event);
        } else if (event instanceof ContextClosedEvent) {
            this.onContextClosedEvent((ContextClosedEvent)event);
        }
    }

    private void onContextRefreshedEvent(ContextRefreshedEvent event) {
        if (this.dubboBootstrap.getTakeoverMode() == BootstrapTakeoverMode.SPRING) {
            this.dubboBootstrap.start();
        }
    }

    private void onContextClosedEvent(ContextClosedEvent event) {
        if (this.dubboBootstrap.getTakeoverMode() == BootstrapTakeoverMode.SPRING) {
            DubboShutdownHook.getDubboShutdownHook().run();
        }
    }

    private boolean isOriginalEventSource(ApplicationEvent event) {
        boolean originalEventSource = ObjectUtils.nullSafeEquals((Object)this.getApplicationContext(), (Object)event.getSource());
        return originalEventSource;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.checkCallStackAndInit();
    }

    private void checkCallStackAndInit() {
        Exception exception = new Exception();
        StackTraceElement[] stackTrace = exception.getStackTrace();
        boolean found = false;
        for (StackTraceElement frame : stackTrace) {
            if (!frame.getMethodName().equals("registerListeners") || !frame.getClassName().endsWith("AbstractApplicationContext")) continue;
            found = true;
            break;
        }
        if (found) {
            this.initDubboConfigBeans();
        } else {
            this.logger.warn((Object)"DubboBootstrapApplicationListener initialization is unexpected, it should be created in AbstractApplicationContext.registerListeners() method", (Throwable)exception);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

