/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.spring.util.ObjectUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.AnnotationUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Method;
import org.apache.dubbo.config.spring.ServiceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.AnnotationPropertyValuesAdapter;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServiceBeanNameBuilder;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServicePackagesHolder;
import org.apache.dubbo.config.spring.context.annotation.DubboClassPathBeanDefinitionScanner;
import org.apache.dubbo.config.spring.util.DubboAnnotationUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class ServiceAnnotationPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware,
ResourceLoaderAware,
BeanClassLoaderAware,
ApplicationContextAware {
    public static final String BEAN_NAME = "dubboServiceAnnotationPostProcessor";
    private static final List<Class<? extends Annotation>> serviceAnnotationTypes = Arrays.asList(DubboService.class, org.apache.dubbo.config.annotation.Service.class, Service.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Set<String> packagesToScan;
    private Environment environment;
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;
    private BeanDefinitionRegistry registry;
    private ServicePackagesHolder servicePackagesHolder;

    public ServiceAnnotationPostProcessor(String ... packagesToScan) {
        this(Arrays.asList(packagesToScan));
    }

    public ServiceAnnotationPostProcessor(Collection<String> packagesToScan) {
        this((Set<String>)new LinkedHashSet<String>(packagesToScan));
    }

    public ServiceAnnotationPostProcessor(Set<String> packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
        Set<String> resolvedPackagesToScan = this.resolvePackagesToScan(this.packagesToScan);
        if (!CollectionUtils.isEmpty(resolvedPackagesToScan)) {
            this.scanServiceBeans(resolvedPackagesToScan, registry);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("packagesToScan is empty , ServiceBean registry will be ignored!");
        }
    }

    private void scanServiceBeans(Set<String> packagesToScan, BeanDefinitionRegistry registry) {
        DubboClassPathBeanDefinitionScanner scanner = new DubboClassPathBeanDefinitionScanner(registry, this.environment, this.resourceLoader);
        BeanNameGenerator beanNameGenerator = this.resolveBeanNameGenerator(registry);
        scanner.setBeanNameGenerator(beanNameGenerator);
        for (Class<? extends Annotation> annotationType : serviceAnnotationTypes) {
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType));
        }
        ScanExcludeFilter scanExcludeFilter = new ScanExcludeFilter();
        scanner.addExcludeFilter(scanExcludeFilter);
        for (String packageToScan : packagesToScan) {
            if (this.servicePackagesHolder.isPackageScanned(packageToScan)) {
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("Ignore package who has already bean scanned: " + packageToScan);
                continue;
            }
            scanner.scan(new String[]{packageToScan});
            Set<BeanDefinitionHolder> beanDefinitionHolders = this.findServiceBeanDefinitionHolders(scanner, packageToScan, registry, beanNameGenerator);
            if (!CollectionUtils.isEmpty(beanDefinitionHolders)) {
                if (this.logger.isInfoEnabled()) {
                    ArrayList<String> serviceClasses = new ArrayList<String>(beanDefinitionHolders.size());
                    for (BeanDefinitionHolder beanDefinitionHolder : beanDefinitionHolders) {
                        serviceClasses.add(beanDefinitionHolder.getBeanDefinition().getBeanClassName());
                    }
                    this.logger.info("Found " + beanDefinitionHolders.size() + " classes annotated by Dubbo @Service under package [" + packageToScan + "]: " + serviceClasses);
                }
                for (BeanDefinitionHolder beanDefinitionHolder : beanDefinitionHolders) {
                    this.processScannedBeanDefinition(beanDefinitionHolder, registry, scanner);
                    this.servicePackagesHolder.addScannedClass(beanDefinitionHolder.getBeanDefinition().getBeanClassName());
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("No class annotated by Dubbo @Service was found under package [" + packageToScan + "], ignore re-scanned classes: " + scanExcludeFilter.getExcludedCount());
            }
            this.servicePackagesHolder.addScannedPackage(packageToScan);
        }
    }

    private BeanNameGenerator resolveBeanNameGenerator(BeanDefinitionRegistry registry) {
        BeanNameGenerator beanNameGenerator = null;
        if (registry instanceof SingletonBeanRegistry) {
            SingletonBeanRegistry singletonBeanRegistry = (SingletonBeanRegistry)SingletonBeanRegistry.class.cast(registry);
            beanNameGenerator = (BeanNameGenerator)singletonBeanRegistry.getSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator");
        }
        if (beanNameGenerator == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("BeanNameGenerator bean can't be found in BeanFactory with name [org.springframework.context.annotation.internalConfigurationBeanNameGenerator]");
                this.logger.info("BeanNameGenerator will be a instance of " + AnnotationBeanNameGenerator.class.getName() + " , it maybe a potential problem on bean name generation.");
            }
            beanNameGenerator = new AnnotationBeanNameGenerator();
        }
        return beanNameGenerator;
    }

    private Set<BeanDefinitionHolder> findServiceBeanDefinitionHolders(ClassPathBeanDefinitionScanner scanner, String packageToScan, BeanDefinitionRegistry registry, BeanNameGenerator beanNameGenerator) {
        Set beanDefinitions = scanner.findCandidateComponents(packageToScan);
        LinkedHashSet<BeanDefinitionHolder> beanDefinitionHolders = new LinkedHashSet<BeanDefinitionHolder>(beanDefinitions.size());
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String beanName = beanNameGenerator.generateBeanName(beanDefinition, registry);
            BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder(beanDefinition, beanName);
            beanDefinitionHolders.add(beanDefinitionHolder);
        }
        return beanDefinitionHolders;
    }

    private void processScannedBeanDefinition(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry registry, DubboClassPathBeanDefinitionScanner scanner) {
        Class<?> beanClass = this.resolveClass(beanDefinitionHolder);
        Annotation service = this.findServiceAnnotation(beanClass);
        Map serviceAnnotationAttributes = com.alibaba.spring.util.AnnotationUtils.getAttributes((Annotation)service, (boolean)true, (String[])new String[0]);
        String serviceInterface = DubboAnnotationUtils.resolveInterfaceName(serviceAnnotationAttributes, beanClass);
        String annotatedServiceBeanName = beanDefinitionHolder.getBeanName();
        String beanName = this.generateServiceBeanName(serviceAnnotationAttributes, serviceInterface);
        AbstractBeanDefinition serviceBeanDefinition = this.buildServiceBeanDefinition(serviceAnnotationAttributes, serviceInterface, annotatedServiceBeanName);
        this.registerServiceBeanDefinition(beanName, serviceBeanDefinition, serviceInterface);
    }

    private Annotation findServiceAnnotation(Class<?> beanClass) {
        return serviceAnnotationTypes.stream().map(annotationType -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)beanClass, (Class)annotationType)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private String generateServiceBeanName(Map<String, Object> serviceAnnotationAttributes, String serviceInterface) {
        ServiceBeanNameBuilder builder = ServiceBeanNameBuilder.create(serviceInterface, this.environment).group((String)serviceAnnotationAttributes.get("group")).version((String)serviceAnnotationAttributes.get("version"));
        return builder.build();
    }

    private Class<?> resolveClass(BeanDefinitionHolder beanDefinitionHolder) {
        BeanDefinition beanDefinition = beanDefinitionHolder.getBeanDefinition();
        return this.resolveClass(beanDefinition);
    }

    private Class<?> resolveClass(BeanDefinition beanDefinition) {
        String beanClassName = beanDefinition.getBeanClassName();
        return ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)this.classLoader);
    }

    private Set<String> resolvePackagesToScan(Set<String> packagesToScan) {
        LinkedHashSet<String> resolvedPackagesToScan = new LinkedHashSet<String>(packagesToScan.size());
        for (String packageToScan : packagesToScan) {
            if (!StringUtils.hasText(packageToScan)) continue;
            String resolvedPackageToScan = this.environment.resolvePlaceholders(packageToScan.trim());
            resolvedPackagesToScan.add(resolvedPackageToScan);
        }
        return resolvedPackagesToScan;
    }

    private AbstractBeanDefinition buildServiceBeanDefinition(Map<String, Object> serviceAnnotationAttributes, String serviceInterface, String refServiceBeanName) {
        String moduleConfigId;
        String applicationConfigId;
        String monitorConfigId;
        String[] protocolConfigIds;
        String[] registryConfigIds;
        String providerConfigId;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ServiceBean.class);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        String[] ignoreAttributeNames = (String[])ObjectUtils.of((Object[])new String[]{"provider", "monitor", "application", "module", "registry", "protocol", "interface", "interfaceName", "parameters"});
        propertyValues.addPropertyValues((PropertyValues)new AnnotationPropertyValuesAdapter(serviceAnnotationAttributes, (PropertyResolver)this.environment, ignoreAttributeNames));
        this.addPropertyReference(builder, "ref", refServiceBeanName);
        builder.addPropertyValue("interface", (Object)serviceInterface);
        builder.addPropertyValue("parameters", DubboAnnotationUtils.convertParameters((String[])serviceAnnotationAttributes.get("parameters")));
        List methodConfigs = this.convertMethodConfigs(serviceAnnotationAttributes.get("methods"));
        if (!methodConfigs.isEmpty()) {
            builder.addPropertyValue("methods", (Object)methodConfigs);
        }
        if (StringUtils.hasText(providerConfigId = (String)serviceAnnotationAttributes.get("provider"))) {
            this.addPropertyValue(builder, "providerIds", providerConfigId);
        }
        if ((registryConfigIds = (String[])serviceAnnotationAttributes.get("registry")) != null && registryConfigIds.length > 0) {
            this.resolveStringArray(registryConfigIds);
            builder.addPropertyValue("registryIds", (Object)StringUtils.join(registryConfigIds, ','));
        }
        if ((protocolConfigIds = (String[])serviceAnnotationAttributes.get("protocol")) != null && protocolConfigIds.length > 0) {
            this.resolveStringArray(protocolConfigIds);
            builder.addPropertyValue("protocolIds", (Object)StringUtils.join(protocolConfigIds, ','));
        }
        if (StringUtils.hasText(monitorConfigId = (String)serviceAnnotationAttributes.get("monitor"))) {
            this.addPropertyReference(builder, "monitor", monitorConfigId);
        }
        if (StringUtils.hasText(applicationConfigId = (String)serviceAnnotationAttributes.get("application"))) {
            this.addPropertyReference(builder, "application", applicationConfigId);
        }
        if (StringUtils.hasText(moduleConfigId = (String)serviceAnnotationAttributes.get("module"))) {
            this.addPropertyReference(builder, "module", moduleConfigId);
        }
        return builder.getBeanDefinition();
    }

    private String[] resolveStringArray(String[] strs) {
        if (strs == null) {
            return null;
        }
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = this.environment.resolvePlaceholders(strs[i]);
        }
        return strs;
    }

    private List convertMethodConfigs(Object methodsAnnotation) {
        if (methodsAnnotation == null) {
            return Collections.EMPTY_LIST;
        }
        return MethodConfig.constructMethodConfig((Method[])methodsAnnotation);
    }

    private void addPropertyReference(BeanDefinitionBuilder builder, String propertyName, String beanName) {
        String resolvedBeanName = this.environment.resolvePlaceholders(beanName);
        builder.addPropertyReference(propertyName, resolvedBeanName);
    }

    private void addPropertyValue(BeanDefinitionBuilder builder, String propertyName, String value) {
        String resolvedBeanName = this.environment.resolvePlaceholders(value);
        builder.addPropertyValue(propertyName, (Object)resolvedBeanName);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames;
        for (String beanName : beanNames = beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            Map<String, Object> annotationAttributes = this.getServiceAnnotationAttributes(beanDefinition);
            if (annotationAttributes == null) continue;
            this.processAnnotatedBeanDefinition(beanName, (AnnotatedBeanDefinition)beanDefinition, annotationAttributes);
        }
    }

    private Map<String, Object> getServiceAnnotationAttributes(BeanDefinition beanDefinition) {
        AnnotatedBeanDefinition annotatedBeanDefinition;
        MethodMetadata factoryMethodMetadata;
        if (beanDefinition instanceof AnnotatedBeanDefinition && (factoryMethodMetadata = (annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata()) != null) {
            for (Class<? extends Annotation> annotationType : serviceAnnotationTypes) {
                if (!factoryMethodMetadata.isAnnotated(annotationType.getName())) continue;
                Map annotationAttributes = factoryMethodMetadata.getAnnotationAttributes(annotationType.getName());
                return AnnotationUtils.filterDefaultValues(annotationType, (Map<String, Object>)annotationAttributes);
            }
        }
        return null;
    }

    private void processAnnotatedBeanDefinition(String refServiceBeanName, AnnotatedBeanDefinition refServiceBeanDefinition, Map<String, Object> attributes) {
        LinkedHashMap<String, Object> serviceAnnotationAttributes = new LinkedHashMap<String, Object>(attributes);
        String returnTypeName = refServiceBeanDefinition.getFactoryMethodMetadata().getReturnTypeName();
        Class beanClass = ClassUtils.resolveClassName((String)returnTypeName, (ClassLoader)this.classLoader);
        String serviceInterface = DubboAnnotationUtils.resolveInterfaceName(serviceAnnotationAttributes, beanClass);
        String serviceBeanName = this.generateServiceBeanName(serviceAnnotationAttributes, serviceInterface);
        AbstractBeanDefinition serviceBeanDefinition = this.buildServiceBeanDefinition(serviceAnnotationAttributes, serviceInterface, refServiceBeanName);
        serviceBeanDefinition.getPropertyValues().add("id", (Object)serviceBeanName);
        this.registerServiceBeanDefinition(serviceBeanName, serviceBeanDefinition, serviceInterface);
    }

    private void registerServiceBeanDefinition(String serviceBeanName, AbstractBeanDefinition serviceBeanDefinition, String serviceInterface) {
        if (this.registry.containsBeanDefinition(serviceBeanName)) {
            BeanDefinition existingDefinition = this.registry.getBeanDefinition(serviceBeanName);
            if (existingDefinition.equals(serviceBeanDefinition)) {
                return;
            }
            String msg = "Found duplicated BeanDefinition of service interface [" + serviceInterface + "] with bean name [" + serviceBeanName + "], existing definition [ " + existingDefinition + "], new definition [" + serviceBeanDefinition + "]";
            this.logger.error(msg);
            throw new BeanDefinitionStoreException(serviceBeanDefinition.getResourceDescription(), serviceBeanName, msg);
        }
        this.registry.registerBeanDefinition(serviceBeanName, (BeanDefinition)serviceBeanDefinition);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Register ServiceBean[" + serviceBeanName + "]: " + serviceBeanDefinition);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.servicePackagesHolder = (ServicePackagesHolder)applicationContext.getBean("dubboServicePackagesHolder", ServicePackagesHolder.class);
    }

    private class ScanExcludeFilter
    implements TypeFilter {
        private int excludedCount;

        private ScanExcludeFilter() {
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            String className = metadataReader.getClassMetadata().getClassName();
            boolean excluded = ServiceAnnotationPostProcessor.this.servicePackagesHolder.isClassScanned(className);
            if (excluded) {
                ++this.excludedCount;
            }
            return excluded;
        }

        public int getExcludedCount() {
            return this.excludedCount;
        }
    }
}

