/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DubboShutdownHook
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(DubboShutdownHook.class);
    private static final DubboShutdownHook DUBBO_SHUTDOWN_HOOK = new DubboShutdownHook("DubboShutdownHook");
    private final ShutdownHookCallbacks callbacks = ShutdownHookCallbacks.INSTANCE;
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    private DubboShutdownHook(String name) {
        super(name);
    }

    public static DubboShutdownHook getDubboShutdownHook() {
        return DUBBO_SHUTDOWN_HOOK;
    }

    @Override
    public void run() {
        String disableShutdownHookValue = (String)ApplicationModel.getEnvironment().getConfiguration().getProperty("dubbo.lifecycle.disable-shutdown-hook", "false");
        if (Boolean.parseBoolean(disableShutdownHookValue)) {
            if (logger.isWarnEnabled()) {
                logger.warn("Shutdown hook is disabled, please shutdown dubbo services by qos manually");
            }
            return;
        }
        if (this.destroyed.compareAndSet(false, true)) {
            if (logger.isInfoEnabled()) {
                logger.info("Run shutdown hook now.");
            }
            this.callback();
            this.doDestroy();
        }
    }

    void clear() {
        this.callbacks.clear();
    }

    private void callback() {
        this.callbacks.callback();
    }

    public void register() {
        if (this.registered.compareAndSet(false, true)) {
            DubboShutdownHook dubboShutdownHook = DubboShutdownHook.getDubboShutdownHook();
            Runtime.getRuntime().addShutdownHook(dubboShutdownHook);
        }
    }

    public void unregister() {
        if (this.registered.compareAndSet(true, false)) {
            DubboShutdownHook dubboShutdownHook = DubboShutdownHook.getDubboShutdownHook();
            Runtime.getRuntime().removeShutdownHook(dubboShutdownHook);
        }
    }

    public void doDestroy() {
        if (logger.isInfoEnabled()) {
            logger.info("Dubbo Service has been destroyed.");
        }
    }

    public boolean getRegistered() {
        return this.registered.get();
    }
}

