/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.serialize.MultipleSerialization;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.utils.ClassUtils;

public class DefaultMultipleSerialization
implements MultipleSerialization {
    @Override
    public void serialize(URL url, String serializeType, String clz, Object obj, OutputStream os) throws IOException {
        serializeType = this.convertHessian(serializeType);
        Serialization serialization = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(serializeType);
        ObjectOutput serialize = serialization.serialize(null, os);
        serialize.writeObject(obj);
        serialize.flushBuffer();
    }

    @Override
    public Object deserialize(URL url, String serializeType, String clz, InputStream os) throws IOException, ClassNotFoundException {
        serializeType = this.convertHessian(serializeType);
        Serialization serialization = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(serializeType);
        Class<?> aClass = ClassUtils.forName(clz);
        ObjectInput in = serialization.deserialize(null, os);
        return in.readObject(aClass);
    }

    private String convertHessian(String ser) {
        if (ser.equals("hessian4")) {
            return "hessian2";
        }
        return ser;
    }
}

