/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.details;

import org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.OldServiceInstance;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;

public class JsonInstanceSerializer<T>
implements InstanceSerializer<T> {
    private final ObjectMapper mapper;
    private final Class<T> payloadClass;
    private final boolean compatibleSerializationMode;
    private final JavaType type;

    public JsonInstanceSerializer(Class<T> payloadClass) {
        this(payloadClass, true, false);
    }

    public JsonInstanceSerializer(Class<T> payloadClass, boolean compatibleSerializationMode) {
        this(payloadClass, compatibleSerializationMode, false);
    }

    @VisibleForTesting
    JsonInstanceSerializer(Class<T> payloadClass, boolean compatibleSerializationMode, boolean failOnUnknownProperties) {
        this.payloadClass = payloadClass;
        this.compatibleSerializationMode = compatibleSerializationMode;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
        this.type = this.mapper.getTypeFactory().constructType(ServiceInstance.class);
    }

    @Override
    public ServiceInstance<T> deserialize(byte[] bytes) throws Exception {
        ServiceInstance rawServiceInstance = (ServiceInstance)this.mapper.readValue(bytes, this.type);
        this.payloadClass.cast(rawServiceInstance.getPayload());
        return rawServiceInstance;
    }

    @Override
    public byte[] serialize(ServiceInstance<T> instance) throws Exception {
        if (this.compatibleSerializationMode) {
            OldServiceInstance<T> compatible = new OldServiceInstance<T>(instance.getName(), instance.getId(), instance.getAddress(), instance.getPort(), instance.getSslPort(), instance.getPayload(), instance.getRegistrationTimeUTC(), instance.getServiceType(), instance.getUriSpec());
            return this.mapper.writeValueAsBytes(compatible);
        }
        return this.mapper.writeValueAsBytes(instance);
    }
}

