/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractFlowNodeBpmnParseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateCatchEventParseHandler
extends AbstractFlowNodeBpmnParseHandler<IntermediateCatchEvent> {
    private static final Logger logger = LoggerFactory.getLogger(IntermediateCatchEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return IntermediateCatchEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, IntermediateCatchEvent event) {
        EventDefinition eventDefinition = null;
        if (!event.getEventDefinitions().isEmpty()) {
            eventDefinition = (EventDefinition)event.getEventDefinitions().get(0);
        }
        if (eventDefinition == null) {
            event.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createIntermediateCatchEventActivityBehavior(event));
        } else if (eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof MessageEventDefinition) {
            bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
        } else {
            logger.warn("Unsupported intermediate catch event type for event " + event.getId());
        }
    }
}

