/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.activiti.dmn.model.DmnExtensionAttribute;
import org.activiti.dmn.model.DmnExtensionElement;

public abstract class DmnElement {
    protected String id;
    protected String label;
    protected String description;
    protected Map<String, List<DmnExtensionElement>> extensionElements = new LinkedHashMap<String, List<DmnExtensionElement>>();
    protected Map<String, List<DmnExtensionAttribute>> attributes = new LinkedHashMap<String, List<DmnExtensionAttribute>>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, List<DmnExtensionElement>> getExtensionElements() {
        return this.extensionElements;
    }

    public void addExtensionElement(DmnExtensionElement extensionElement) {
        if (extensionElement != null && extensionElement.getName() != null && !extensionElement.getName().trim().isEmpty()) {
            ArrayList elementList = null;
            if (!this.extensionElements.containsKey(extensionElement.getName())) {
                elementList = new ArrayList();
                this.extensionElements.put(extensionElement.getName(), elementList);
            }
            this.extensionElements.get(extensionElement.getName()).add(extensionElement);
        }
    }

    public void setExtensionElements(Map<String, List<DmnExtensionElement>> extensionElements) {
        this.extensionElements = extensionElements;
    }

    public Map<String, List<DmnExtensionAttribute>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<DmnExtensionAttribute>> attributes) {
        this.attributes = attributes;
    }

    public String getAttributeValue(String namespace, String name) {
        List<DmnExtensionAttribute> attributes = this.getAttributes().get(name);
        if (attributes != null && !attributes.isEmpty()) {
            for (DmnExtensionAttribute attribute : attributes) {
                if ((namespace != null || attribute.getNamespace() != null) && !namespace.equals(attribute.getNamespace())) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public void addAttribute(DmnExtensionAttribute attribute) {
        if (attribute != null && attribute.getName() != null && !attribute.getName().trim().isEmpty()) {
            ArrayList attributeList = null;
            if (!this.attributes.containsKey(attribute.getName())) {
                attributeList = new ArrayList();
                this.attributes.put(attribute.getName(), attributeList);
            }
            this.attributes.get(attribute.getName()).add(attribute);
        }
    }

    public void setValues(DmnElement otherElement) {
        this.setId(otherElement.getId());
        this.extensionElements = new LinkedHashMap<String, List<DmnExtensionElement>>();
        if (otherElement.getExtensionElements() != null && !otherElement.getExtensionElements().isEmpty()) {
            for (String key : otherElement.getExtensionElements().keySet()) {
                List<DmnExtensionElement> otherElementList = otherElement.getExtensionElements().get(key);
                if (otherElementList == null || otherElementList.isEmpty()) continue;
                ArrayList<DmnExtensionElement> elementList = new ArrayList<DmnExtensionElement>();
                for (DmnExtensionElement extensionElement : otherElementList) {
                    elementList.add(extensionElement.clone());
                }
                this.extensionElements.put(key, elementList);
            }
        }
        this.attributes = new LinkedHashMap<String, List<DmnExtensionAttribute>>();
        if (otherElement.getAttributes() != null && !otherElement.getAttributes().isEmpty()) {
            for (String key : otherElement.getAttributes().keySet()) {
                List<DmnExtensionAttribute> otherAttributeList = otherElement.getAttributes().get(key);
                if (otherAttributeList == null || otherAttributeList.isEmpty()) continue;
                ArrayList<DmnExtensionAttribute> attributeList = new ArrayList<DmnExtensionAttribute>();
                for (DmnExtensionAttribute extensionAttribute : otherAttributeList) {
                    attributeList.add(extensionAttribute.clone());
                }
                this.attributes.put(key, attributeList);
            }
        }
    }
}

