/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.TTLTimer;
import netscape.ldap.util.DN;

public class LDAPCache
implements Serializable {
    static final long serialVersionUID = 6275167993337814294L;
    private Hashtable m_cache;
    private long m_timeToLive;
    private long m_maxSize;
    private String[] m_dns;
    private Vector m_orderedStruct;
    private long m_remainingSize = 0L;
    private int m_refCnt = 0;
    public static final String DELIM = "#";
    private TTLTimer m_timer = null;
    private long m_totalOpers = 0L;
    private long m_hits = 0L;
    private long m_flushes = 0L;
    private static boolean m_debug = false;

    static {
        try {
            String string = System.getProperty("debug.cache");
            m_debug = string != null;
        }
        catch (Exception exception) {}
    }

    public LDAPCache(long l, long l2) {
        this.init(l, l2);
    }

    public LDAPCache(long l, long l2, String[] stringArray) {
        this.init(l, l2);
        this.m_dns = new String[stringArray.length];
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                this.m_dns[n] = new DN(stringArray[n]).toString();
                ++n;
            }
        }
    }

    synchronized boolean addEntry(Long l, Object object) {
        Vector<Long> vector;
        if (this.m_cache.get(l) != null) {
            return false;
        }
        Vector vector2 = (Vector)object;
        long l2 = (Long)vector2.elementAt(0);
        if (l2 > this.m_maxSize) {
            if (m_debug) {
                System.out.println("Failed to add an entry to the cache since the new entry exceeds the cache size");
            }
            return false;
        }
        if (l2 > this.m_remainingSize) {
            do {
                vector = (Vector<Long>)this.m_orderedStruct.firstElement();
                Long l3 = (Long)vector.elementAt(0);
                Vector vector3 = (Vector)this.m_cache.remove(l3);
                if (m_debug) {
                    System.out.println("DEBUG: The spare size of the cache is not big enough to hold the new entry, deleting the entry whose key -> " + l3);
                }
                this.m_orderedStruct.removeElementAt(0);
                this.m_remainingSize += ((Long)vector3.elementAt(0)).longValue();
            } while (this.m_remainingSize < l2);
        }
        this.m_remainingSize -= l2;
        this.m_cache.put(l, vector2);
        vector = new Vector<Long>();
        vector.addElement(l);
        vector.addElement(new Long(System.currentTimeMillis()));
        this.m_orderedStruct.addElement(vector);
        if (this.m_orderedStruct.size() == 1) {
            this.scheduleTTLTimer();
        }
        if (m_debug) {
            System.out.println("DEBUG: Adding a new entry whose key -> " + l);
            System.out.println("DEBUG: The current number of keys in the cache " + this.m_cache.size());
        }
        return true;
    }

    synchronized void addReference() {
        ++this.m_refCnt;
        if (m_debug) {
            System.err.println("Cache refCnt=" + this.m_refCnt);
        }
    }

    private String appendString(int n) {
        return String.valueOf(n) + DELIM;
    }

    private String appendString(String string) {
        if (string == null) {
            return "null#";
        }
        return String.valueOf(string.trim()) + DELIM;
    }

    private String appendString(String[] stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            return "0#";
        }
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        this.sortStrings(stringArray2);
        String string = String.valueOf(stringArray2.length) + DELIM;
        int n = 0;
        while (n < stringArray2.length) {
            string = String.valueOf(string) + stringArray2[n].trim() + DELIM;
            ++n;
        }
        return string;
    }

    synchronized void cleanup() {
        this.flushEntries(null, 0);
        if (this.m_timer != null) {
            this.m_timer.stop();
            this.m_timer = null;
        }
    }

    Long createKey(String string, int n, String string2, String string3, int n2, String[] stringArray, String string4, LDAPConstraints lDAPConstraints) throws LDAPException {
        long l;
        LDAPControl lDAPControl;
        int n3;
        String[] stringArray2;
        DN dN = new DN(string2);
        string2 = dN.toString();
        if (this.m_dns != null) {
            int n4 = 0;
            while (n4 < this.m_dns.length) {
                if (string2.equals(this.m_dns[n4])) break;
                ++n4;
            }
            if (n4 >= this.m_dns.length) {
                throw new LDAPException(String.valueOf(string2) + " is not a cached base DN", 80);
            }
        }
        String string5 = null;
        string5 = this.appendString(string2);
        string5 = String.valueOf(string5) + this.appendString(n2);
        string5 = String.valueOf(string5) + this.appendString(string);
        string5 = String.valueOf(string5) + this.appendString(n);
        string5 = String.valueOf(string5) + this.appendString(string3);
        string5 = String.valueOf(string5) + this.appendString(stringArray);
        string5 = String.valueOf(string5) + this.appendString(string4);
        LDAPControl[] lDAPControlArray = null;
        LDAPControl[] lDAPControlArray2 = null;
        if (lDAPConstraints != null) {
            lDAPControlArray = lDAPConstraints.getServerControls();
            lDAPControlArray2 = lDAPConstraints.getClientControls();
        }
        if (lDAPControlArray != null && lDAPControlArray.length > 0) {
            stringArray2 = new String[lDAPControlArray.length];
            n3 = 0;
            while (n3 < lDAPControlArray.length) {
                lDAPControl = lDAPControlArray[n3];
                l = this.getCRC32(lDAPControl.getValue());
                stringArray2[n3] = String.valueOf(lDAPControl.getID()) + lDAPControl.isCritical() + new Long(l).toString();
                ++n3;
            }
            string5 = String.valueOf(string5) + this.appendString(stringArray2);
        } else {
            string5 = String.valueOf(string5) + this.appendString(0);
        }
        if (lDAPControlArray2 != null && lDAPControlArray2.length > 0) {
            stringArray2 = new String[lDAPControlArray2.length];
            n3 = 0;
            while (n3 < lDAPControlArray2.length) {
                lDAPControl = lDAPControlArray2[n3];
                l = this.getCRC32(lDAPControl.getValue());
                stringArray2[n3] = String.valueOf(lDAPControl.getID()) + lDAPControl.isCritical() + new Long(l).toString();
                ++n3;
            }
            string5 = String.valueOf(string5) + this.appendString(stringArray2);
        } else {
            string5 = String.valueOf(string5) + this.appendString(0);
        }
        long l2 = this.getCRC32(string5.getBytes());
        if (m_debug) {
            System.out.println("key=" + l2 + " for " + string5);
        }
        return new Long(l2);
    }

    synchronized void flushEntries() {
        long l;
        Vector vector = null;
        boolean bl = false;
        long l2 = System.currentTimeMillis();
        this.m_flushes = 0L;
        while (this.m_orderedStruct.size() > 0 && (l = l2 - (Long)(vector = (Vector)this.m_orderedStruct.firstElement()).elementAt(1)) >= this.m_timeToLive) {
            Long l3 = (Long)vector.elementAt(0);
            if (m_debug) {
                System.out.println("DEBUG: Timer flush entry whose key is " + l3);
            }
            Vector vector2 = (Vector)this.m_cache.remove(l3);
            this.m_remainingSize += ((Long)vector2.firstElement()).longValue();
            this.m_orderedStruct.removeElementAt(0);
            ++this.m_flushes;
        }
        if (m_debug) {
            System.out.println("DEBUG: The number of keys in the cache is " + this.m_cache.size());
        }
    }

    public synchronized boolean flushEntries(String string, int n) {
        if (m_debug) {
            System.out.println("DEBUG: User request for flushing entry: dn " + string + " and scope " + n);
        }
        if (string == null) {
            this.m_remainingSize = this.m_maxSize;
            this.m_cache.clear();
            this.m_orderedStruct.removeAllElements();
            this.m_flushes = 0L;
            this.m_hits = 0L;
            this.m_totalOpers = 0L;
            return true;
        }
        DN dN = new DN(string);
        Enumeration enumeration = this.m_cache.keys();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            Long l = (Long)enumeration.nextElement();
            Vector vector = (Vector)this.m_cache.get(l);
            int n2 = 1;
            int n3 = vector.size();
            while (n2 < n3) {
                DN dN2;
                String string2 = ((LDAPEntry)vector.elementAt(n2)).getDN();
                serializable = new DN(string2);
                if (((DN)serializable).equals(dN) || n == 1 && (dN2 = ((DN)serializable).getParent()).equals(dN) || n == 2 && ((DN)serializable).isDescendantOf(dN)) break;
                ++n2;
            }
            if (n2 >= n3) continue;
            int n4 = 0;
            while (n4 < this.m_orderedStruct.size()) {
                serializable = (Vector)this.m_orderedStruct.elementAt(n4);
                if (l.equals((Long)((Vector)serializable).elementAt(0))) {
                    this.m_orderedStruct.removeElementAt(n4);
                    break;
                }
                ++n4;
            }
            this.m_cache.remove(l);
            if (m_debug) {
                System.out.println("DEBUG: Successfully removed entry ->" + l);
            }
            return true;
        }
        if (m_debug) {
            System.out.println("DEBUG: The number of keys in the cache is " + this.m_cache.size());
        }
        return false;
    }

    public long getAvailableSize() {
        return this.m_remainingSize;
    }

    public String[] getBaseDNs() {
        return this.m_dns;
    }

    private long getCRC32(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return cRC32.getValue();
    }

    synchronized Object getEntry(Long l) {
        Object var2_2 = null;
        var2_2 = this.m_cache.get(l);
        ++this.m_totalOpers;
        if (m_debug) {
            if (var2_2 == null) {
                System.out.println("DEBUG: Entry whose key -> " + l + " not found in the cache.");
            } else {
                System.out.println("DEBUG: Entry whose key -> " + l + " found in the cache.");
            }
        }
        if (var2_2 != null) {
            ++this.m_hits;
        }
        return var2_2;
    }

    public int getNumEntries() {
        return this.m_cache.size();
    }

    public long getNumFlushes() {
        return this.m_flushes;
    }

    public long getNumHits() {
        return this.m_hits;
    }

    public long getNumMisses() {
        return this.m_totalOpers - this.m_hits;
    }

    int getRefCount() {
        return this.m_refCnt;
    }

    public long getSize() {
        return this.m_maxSize;
    }

    public long getTimeToLive() {
        return this.m_timeToLive / 1000L;
    }

    public long getTotalOperations() {
        return this.m_totalOpers;
    }

    private void init(long l, long l2) {
        this.m_cache = new Hashtable();
        this.m_timeToLive = l * 1000L;
        this.m_maxSize = l2;
        this.m_remainingSize = l2;
        this.m_dns = null;
        this.m_orderedStruct = new Vector();
    }

    synchronized void removeReference() {
        if (this.m_refCnt > 0) {
            --this.m_refCnt;
            if (m_debug) {
                System.err.println("Cache refCnt=" + this.m_refCnt);
            }
            if (this.m_refCnt == 0) {
                this.cleanup();
            }
        }
    }

    synchronized void scheduleTTLTimer() {
        if (this.m_orderedStruct.size() <= 0) {
            return;
        }
        if (this.m_timer == null) {
            this.m_timer = new TTLTimer(this);
        }
        Vector vector = (Vector)this.m_orderedStruct.firstElement();
        long l = System.currentTimeMillis();
        long l2 = (Long)vector.elementAt(1);
        long l3 = l2 + this.m_timeToLive - l;
        if (l3 > 0L) {
            this.m_timer.start(l3);
        } else {
            this.flushEntries();
            this.scheduleTTLTimer();
        }
    }

    private void sortStrings(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].trim();
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length - 1) {
            int n3 = n2 + 1;
            while (n3 < stringArray.length) {
                if (stringArray[n2].compareTo(stringArray[n3]) > 0) {
                    String string = stringArray[n2];
                    stringArray[n2] = stringArray[n3];
                    stringArray[n3] = string;
                }
                ++n3;
            }
            ++n2;
        }
    }
}

