/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERSet;

public class LDAPAttribute
implements Serializable {
    static final long serialVersionUID = -4594745735452202600L;
    private String name = null;
    private byte[] nameBuf = null;
    private Object[] values = new Object[0];

    public LDAPAttribute(String string) {
        this.name = string;
    }

    public LDAPAttribute(String string, String string2) {
        this.name = string;
        this.addValue(string2);
    }

    public LDAPAttribute(String string, byte[] byArray) {
        this.name = string;
        this.addValue(byArray);
    }

    public LDAPAttribute(String string, String[] stringArray) {
        this.name = string;
        if (stringArray != null) {
            this.setValues(stringArray);
        }
    }

    public LDAPAttribute(LDAPAttribute lDAPAttribute) {
        this.name = lDAPAttribute.name;
        this.nameBuf = lDAPAttribute.nameBuf;
        this.values = new Object[lDAPAttribute.values.length];
        int n = 0;
        while (n < lDAPAttribute.values.length) {
            this.values[n] = new byte[((byte[])lDAPAttribute.values[n]).length];
            System.arraycopy((byte[])lDAPAttribute.values[n], 0, (byte[])this.values[n], 0, ((byte[])lDAPAttribute.values[n]).length);
            ++n;
        }
    }

    public LDAPAttribute(BERElement bERElement) throws IOException {
        BERSequence bERSequence = (BERSequence)bERElement;
        BEROctetString bEROctetString = (BEROctetString)bERSequence.elementAt(0);
        this.nameBuf = bEROctetString.getValue();
        BERSet bERSet = (BERSet)bERSequence.elementAt(1);
        if (bERSet.size() > 0) {
            Object[] objectArray = new Object[bERSet.size()];
            int n = 0;
            while (n < bERSet.size()) {
                objectArray[n] = ((BEROctetString)bERSet.elementAt(n)).getValue();
                ++n;
            }
            this.setValues(objectArray);
        }
    }

    public synchronized void addValue(String string) {
        block2: {
            if (string == null) break block2;
            try {
                byte[] byArray = string.getBytes("UTF8");
                this.addValue(byArray);
            }
            catch (Throwable throwable) {}
        }
    }

    public synchronized void addValue(byte[] byArray) {
        if (byArray != null) {
            Object[] objectArray = new Object[this.values.length + 1];
            int n = 0;
            while (n < this.values.length) {
                objectArray[n] = this.values[n];
                ++n;
            }
            objectArray[this.values.length] = byArray;
            this.values = objectArray;
        }
    }

    private static boolean equalValue(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public BERElement getBERElement() {
        try {
            BERSequence bERSequence = new BERSequence();
            bERSequence.addElement(new BEROctetString(this.getName()));
            BERSet bERSet = new BERSet();
            int n = 0;
            while (n < this.values.length) {
                bERSet.addElement(new BEROctetString((byte[])this.values[n]));
                ++n;
            }
            bERSequence.addElement(bERSet);
            return bERSequence;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getBaseName() {
        return LDAPAttribute.getBaseName(this.getName());
    }

    public static String getBaseName(String string) {
        String string2 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.hasMoreElements()) {
            string2 = (String)stringTokenizer.nextElement();
        }
        return string2;
    }

    public byte[][] getByteValueArray() {
        byte[][] byArray = new byte[this.values.length][];
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            try {
                int n = 0;
                while (n < this.values.length) {
                    byArray[n] = new byte[((byte[])this.values[n]).length];
                    System.arraycopy((byte[])this.values[n], 0, byArray[n], 0, ((byte[])this.values[n]).length);
                    ++n;
                }
            }
            catch (Exception exception) {
                byte[][] byArray2 = null;
                Object var4_5 = null;
                return byArray2;
            }
        }
        return byArray;
    }

    public Enumeration getByteValues() {
        Vector<Object> vector = new Vector<Object>();
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            int n = 0;
            while (n < this.values.length) {
                if (this.values[n] != null) {
                    vector.addElement(this.values[n]);
                } else {
                    vector.addElement(new byte[0]);
                }
                ++n;
            }
        }
        return vector.elements();
    }

    public String getLangSubtype() {
        String[] stringArray = this.getSubtypes();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].length() >= 5 && stringArray[n].substring(0, 5).equalsIgnoreCase("lang-")) {
                    return stringArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public String getName() {
        block2: {
            if (this.name != null || this.nameBuf == null) break block2;
            try {
                this.name = new String(this.nameBuf, "UTF8");
            }
            catch (Throwable throwable) {}
        }
        return this.name;
    }

    private String getParamString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.values.length > 0) {
            int n = 0;
            while (n < this.values.length) {
                if (n != 0) {
                    stringBuffer.append(",");
                }
                byte[] byArray = (byte[])this.values[n];
                try {
                    stringBuffer.append(new String(byArray, "UTF8"));
                }
                catch (Exception exception) {
                    if (byArray != null) {
                        stringBuffer.append(byArray.length);
                        stringBuffer.append(" bytes");
                    }
                    stringBuffer.append("null value");
                }
                ++n;
            }
        }
        return "{type='" + this.getName() + "', values='" + stringBuffer.toString() + "'}";
    }

    public String[] getStringValueArray() {
        String[] stringArray = new String[this.values.length];
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            try {
                int n = 0;
                while (n < this.values.length) {
                    stringArray[n] = this.values[n] != null ? new String((byte[])this.values[n], "UTF8") : new String("");
                    ++n;
                }
            }
            catch (Exception exception) {
                String[] stringArray2 = null;
                Object var4_5 = null;
                return stringArray2;
            }
        }
        return stringArray;
    }

    public Enumeration getStringValues() {
        Vector<String> vector = new Vector<String>();
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            try {
                int n = 0;
                while (n < this.values.length) {
                    if (this.values[n] != null) {
                        vector.addElement(new String((byte[])this.values[n], "UTF8"));
                    } else {
                        vector.addElement(new String(""));
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                Enumeration enumeration = null;
                Object var4_5 = null;
                return enumeration;
            }
        }
        return vector.elements();
    }

    public String[] getSubtypes() {
        return LDAPAttribute.getSubtypes(this.getName());
    }

    public static String[] getSubtypes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.hasMoreElements()) {
            stringTokenizer.nextElement();
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                stringArray[n++] = (String)stringTokenizer.nextElement();
            }
            return stringArray;
        }
        return null;
    }

    public boolean hasSubtype(String string) {
        String[] stringArray = this.getSubtypes();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasSubtypes(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (!this.hasSubtype(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized void removeValue(String string) {
        block2: {
            if (string == null) break block2;
            try {
                byte[] byArray = string.getBytes("UTF8");
                this.removeValue(byArray);
            }
            catch (Throwable throwable) {}
        }
    }

    public synchronized void removeValue(byte[] byArray) {
        if (byArray == null || this.values == null || this.values.length < 1) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.values.length) {
            if (LDAPAttribute.equalValue(byArray, (byte[])this.values[n2])) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n >= 0) {
            Object[] objectArray = new Object[this.values.length - 1];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.values.length) {
                if (n4 != n) {
                    objectArray[n3++] = this.values[n4];
                }
                ++n4;
            }
            this.values = objectArray;
        }
    }

    protected synchronized void setValues(Object[] objectArray) {
        this.values = objectArray;
    }

    protected void setValues(String[] stringArray) {
        Object[] objectArray;
        if (stringArray != null) {
            objectArray = new Object[stringArray.length];
            int n = 0;
            while (n < objectArray.length) {
                try {
                    objectArray[n] = stringArray[n].getBytes("UTF8");
                }
                catch (Throwable throwable) {
                    objectArray[n] = new byte[0];
                }
                ++n;
            }
        } else {
            objectArray = new Object[]{};
        }
        this.setValues(objectArray);
    }

    public int size() {
        return this.values.length;
    }

    public String toString() {
        return "LDAPAttribute " + this.getParamString();
    }
}

