/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.classmate.members.ResolvedParameterizedMember;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ModelPropertyBuilder;
import springfox.documentation.schema.Annotations;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.BeanPropertyDefinitions;
import springfox.documentation.schema.property.BeanPropertyNamingStrategy;
import springfox.documentation.schema.property.FactoryMethodProvider;
import springfox.documentation.schema.property.ModelPropertiesProvider;
import springfox.documentation.schema.property.SimpleMethodSignatureEquality;
import springfox.documentation.schema.property.bean.AccessorsProvider;
import springfox.documentation.schema.property.bean.BeanModelProperty;
import springfox.documentation.schema.property.bean.ParameterModelProperty;
import springfox.documentation.schema.property.field.FieldModelProperty;
import springfox.documentation.schema.property.field.FieldProvider;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Primary
@Component(value="optimized")
public class OptimizedModelPropertiesProvider
implements ModelPropertiesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizedModelPropertiesProvider.class);
    private final AccessorsProvider accessors;
    private final FieldProvider fields;
    private final FactoryMethodProvider factoryMethods;
    private final TypeResolver typeResolver;
    private final BeanPropertyNamingStrategy namingStrategy;
    private final SchemaPluginsManager schemaPluginsManager;
    private final JacksonAnnotationIntrospector annotationIntrospector;
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final TypeNameExtractor typeNameExtractor;
    private ObjectMapper objectMapper;

    @Autowired
    public OptimizedModelPropertiesProvider(AccessorsProvider accessors, FieldProvider fields, FactoryMethodProvider factoryMethods, TypeResolver typeResolver, BeanPropertyNamingStrategy namingStrategy, SchemaPluginsManager schemaPluginsManager, EnumTypeDeterminer enumTypeDeterminer, TypeNameExtractor typeNameExtractor) {
        this.accessors = accessors;
        this.fields = fields;
        this.factoryMethods = factoryMethods;
        this.typeResolver = typeResolver;
        this.namingStrategy = namingStrategy;
        this.schemaPluginsManager = schemaPluginsManager;
        this.annotationIntrospector = new JacksonAnnotationIntrospector();
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.typeNameExtractor = typeNameExtractor;
    }

    public void onApplicationEvent(ObjectMapperConfigured event) {
        this.objectMapper = event.getObjectMapper();
    }

    @Override
    public List<ModelProperty> propertiesFor(ResolvedType type, ModelContext givenContext) {
        List<ModelProperty> syntheticProperties = this.schemaPluginsManager.syntheticProperties(givenContext);
        if (!syntheticProperties.isEmpty()) {
            return syntheticProperties;
        }
        return this.propertiesFor(type, givenContext, "");
    }

    private List<ModelProperty> propertiesFor(ResolvedType type, ModelContext givenContext, String namePrefix) {
        TreeSet<ModelProperty> properties = new TreeSet<ModelProperty>(this.byPropertyName());
        BeanDescription beanDescription = this.beanDescription(type, givenContext);
        Map propertyLookup = beanDescription.findProperties().stream().collect(Collectors.toMap(BeanPropertyDefinitions.beanPropertyByInternalName(), Function.identity()));
        for (Map.Entry each : propertyLookup.entrySet()) {
            LOG.debug("Reading property {}", (Object)each.getKey());
            BeanPropertyDefinition jacksonProperty = (BeanPropertyDefinition)each.getValue();
            Optional<AnnotatedMember> annotatedMember = Optional.ofNullable(this.safeGetPrimaryMember(jacksonProperty, givenContext));
            annotatedMember.ifPresent(member -> properties.addAll(this.candidateProperties(type, (AnnotatedMember)member, jacksonProperty, givenContext, namePrefix)));
        }
        return new ArrayList<ModelProperty>(properties);
    }

    private Comparator<ModelProperty> byPropertyName() {
        return Comparator.comparing(ModelProperty::getName);
    }

    private AnnotatedMember safeGetPrimaryMember(BeanPropertyDefinition jacksonProperty, ModelContext givenContext) {
        try {
            if (givenContext.isReturnType()) {
                return jacksonProperty.getAccessor();
            }
            return jacksonProperty.getMutator();
        }
        catch (IllegalArgumentException e) {
            LOG.warn(String.format("Unable to get unique property. %s", e.getMessage()));
            return null;
        }
    }

    private Function<ResolvedMethod, List<ModelProperty>> propertyFromBean(ModelContext givenContext, BeanPropertyDefinition jacksonProperty, String namePrefix) {
        return input -> {
            ResolvedType type = BeanModelProperty.paramOrReturnType(this.typeResolver, input);
            if (!givenContext.canIgnore(type)) {
                if (Annotations.memberIsUnwrapped(jacksonProperty.getPrimaryMember())) {
                    return this.propertiesFor(type, ModelContext.fromParent((ModelContext)givenContext, (ResolvedType)type), String.format("%s%s", namePrefix, Annotations.unwrappedPrefix(jacksonProperty.getPrimaryMember())));
                }
                return Collections.singletonList(this.beanModelProperty((ResolvedMethod)input, jacksonProperty, givenContext, namePrefix));
            }
            return new ArrayList();
        };
    }

    private Function<ResolvedField, List<ModelProperty>> propertyFromField(ModelContext givenContext, BeanPropertyDefinition jacksonProperty, String namePrefix) {
        return input -> {
            if (!givenContext.canIgnore(input.getType())) {
                if (Annotations.memberIsUnwrapped((AnnotatedMember)jacksonProperty.getField())) {
                    return this.propertiesFor(input.getType(), ModelContext.fromParent((ModelContext)givenContext, (ResolvedType)input.getType()), String.format("%s%s", namePrefix, Annotations.unwrappedPrefix(jacksonProperty.getPrimaryMember())));
                }
                return Collections.singletonList(this.fieldModelProperty((ResolvedField)input, jacksonProperty, givenContext, namePrefix));
            }
            return new ArrayList();
        };
    }

    private List<ModelProperty> candidateProperties(ResolvedType type, AnnotatedMember member, BeanPropertyDefinition jacksonProperty, ModelContext givenContext, String namePrefix) {
        ArrayList<ModelProperty> properties = new ArrayList<ModelProperty>();
        if (!this.isInActiveView(member, givenContext)) {
            return properties;
        }
        if (member instanceof AnnotatedMethod) {
            properties.addAll(this.findAccessorMethod(type, member).map(this.propertyFromBean(givenContext, jacksonProperty, namePrefix)).orElse(new ArrayList()));
        } else if (member instanceof AnnotatedField) {
            properties.addAll(this.findField(type, jacksonProperty.getInternalName()).map(this.propertyFromField(givenContext, jacksonProperty, namePrefix)).orElse(new ArrayList()));
        } else if (member instanceof AnnotatedParameter) {
            ModelContext modelContext = ModelContext.fromParent((ModelContext)givenContext, (ResolvedType)type);
            properties.addAll(this.fromFactoryMethod(type, jacksonProperty, (AnnotatedParameter)member, modelContext, namePrefix));
        }
        return properties.stream().filter(this.hiddenProperties()).collect(Collectors.toList());
    }

    private boolean isInActiveView(AnnotatedMember member, ModelContext givenContext) {
        if (givenContext.getView().isPresent()) {
            Class[] typeViews = this.annotationIntrospector.findViews((Annotated)member);
            if (typeViews == null) {
                typeViews = new Class[]{};
            }
            if (typeViews.length == 0 && this.objectMapper.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION)) {
                return true;
            }
            Class activeView = ((ResolvedType)givenContext.getView().get()).getErasedType();
            int len = typeViews.length;
            for (int i = 0; i < len; ++i) {
                if (!typeViews[i].isAssignableFrom(activeView)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private Predicate<? super ModelProperty> hiddenProperties() {
        return input -> !input.isHidden();
    }

    private Optional<ResolvedField> findField(ResolvedType resolvedType, String fieldName) {
        return StreamSupport.stream(this.fields.in(resolvedType).spliterator(), false).filter(input -> fieldName.equals(input.getName())).findFirst();
    }

    private ModelProperty fieldModelProperty(ResolvedField childField, BeanPropertyDefinition jacksonProperty, ModelContext modelContext, String namePrefix) {
        String fieldName = BeanPropertyDefinitions.name(jacksonProperty, modelContext.isReturnType(), this.namingStrategy, namePrefix);
        FieldModelProperty fieldModelProperty = new FieldModelProperty(fieldName, childField, this.typeResolver, modelContext.getAlternateTypeProvider(), jacksonProperty);
        ModelPropertyBuilder propertyBuilder = new ModelPropertyBuilder().name(fieldModelProperty.getName()).type(fieldModelProperty.getType()).qualifiedType(fieldModelProperty.qualifiedTypeName()).position(fieldModelProperty.position()).required(Boolean.valueOf(fieldModelProperty.isRequired())).description(fieldModelProperty.propertyDescription()).allowableValues(fieldModelProperty.allowableValues()).example(fieldModelProperty.example());
        return this.schemaPluginsManager.property(new ModelPropertyContext(propertyBuilder, (AnnotatedElement)((Object)childField.getRawMember()), this.typeResolver, modelContext.getDocumentationType())).updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.enumTypeDeterminer, this.typeNameExtractor));
    }

    private ModelProperty beanModelProperty(ResolvedMethod childProperty, BeanPropertyDefinition jacksonProperty, ModelContext modelContext, String namePrefix) {
        String propertyName = BeanPropertyDefinitions.name(jacksonProperty, modelContext.isReturnType(), this.namingStrategy, namePrefix);
        BeanModelProperty beanModelProperty = new BeanModelProperty(propertyName, childProperty, this.typeResolver, modelContext.getAlternateTypeProvider(), jacksonProperty);
        LOG.debug("Adding property {} to model", (Object)propertyName);
        ModelPropertyBuilder propertyBuilder = new ModelPropertyBuilder().name(beanModelProperty.getName()).type(beanModelProperty.getType()).qualifiedType(beanModelProperty.qualifiedTypeName()).position(beanModelProperty.position()).required(Boolean.valueOf(beanModelProperty.isRequired())).isHidden(Boolean.valueOf(false)).description(beanModelProperty.propertyDescription()).allowableValues(beanModelProperty.allowableValues()).example(beanModelProperty.example());
        return this.schemaPluginsManager.property(new ModelPropertyContext(propertyBuilder, jacksonProperty, this.typeResolver, modelContext.getDocumentationType())).updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.enumTypeDeterminer, this.typeNameExtractor));
    }

    private ModelProperty paramModelProperty(ResolvedParameterizedMember constructor, BeanPropertyDefinition jacksonProperty, AnnotatedParameter parameter, ModelContext modelContext, String namePrefix) {
        String propertyName = BeanPropertyDefinitions.name(jacksonProperty, modelContext.isReturnType(), this.namingStrategy, namePrefix);
        ParameterModelProperty parameterModelProperty = new ParameterModelProperty(propertyName, parameter, constructor, this.typeResolver, modelContext.getAlternateTypeProvider(), jacksonProperty);
        LOG.debug("Adding property {} to model", (Object)propertyName);
        ModelPropertyBuilder propertyBuilder = new ModelPropertyBuilder().name(parameterModelProperty.getName()).type(parameterModelProperty.getType()).qualifiedType(parameterModelProperty.qualifiedTypeName()).position(parameterModelProperty.position()).required(Boolean.valueOf(parameterModelProperty.isRequired())).isHidden(Boolean.valueOf(false)).description(parameterModelProperty.propertyDescription()).allowableValues(parameterModelProperty.allowableValues()).example(parameterModelProperty.example());
        return this.schemaPluginsManager.property(new ModelPropertyContext(propertyBuilder, jacksonProperty, this.typeResolver, modelContext.getDocumentationType())).updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.enumTypeDeterminer, this.typeNameExtractor));
    }

    private Optional<ResolvedMethod> findAccessorMethod(ResolvedType resolvedType, AnnotatedMember member) {
        return this.accessors.in(resolvedType).stream().filter(accessorMethod -> {
            SimpleMethodSignatureEquality methodComparer = new SimpleMethodSignatureEquality();
            return methodComparer.test((Method)accessorMethod.getRawMember(), (Method)member.getMember());
        }).findFirst();
    }

    private List<ModelProperty> fromFactoryMethod(ResolvedType resolvedType, BeanPropertyDefinition beanProperty, AnnotatedParameter member, ModelContext givenContext, String namePrefix) {
        Optional<ModelProperty> property = this.factoryMethods.in(resolvedType, FactoryMethodProvider.factoryMethodOf(member)).map(input -> this.paramModelProperty((ResolvedParameterizedMember)input, beanProperty, member, givenContext, namePrefix));
        return property.map(Collections::singletonList).orElseGet(ArrayList::new);
    }

    private BeanDescription beanDescription(ResolvedType type, ModelContext context) {
        if (context.isReturnType()) {
            SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
            return serializationConfig.introspect(serializationConfig.constructType(type.getErasedType()));
        }
        DeserializationConfig serializationConfig = this.objectMapper.getDeserializationConfig();
        return serializationConfig.introspect(serializationConfig.constructType(type.getErasedType()));
    }
}

