/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.types.ResolvedPrimitiveType;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.contexts.ModelContext;

class ModelReferenceProvider
implements Function<ResolvedType, ModelReference> {
    private final TypeNameExtractor typeNameExtractor;
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final ModelContext parentContext;
    private final Map<String, String> knownNames;

    ModelReferenceProvider(TypeNameExtractor typeNameExtractor, EnumTypeDeterminer enumTypeDeterminer, ModelContext parentContext, Map<String, String> knownNames) {
        this.typeNameExtractor = typeNameExtractor;
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.parentContext = parentContext;
        this.knownNames = java.util.Collections.unmodifiableMap(knownNames);
    }

    @Override
    public ModelReference apply(ResolvedType type) {
        return this.collectionReference(type).map(Optional::of).orElse(this.mapReference(type)).orElse(this.modelReference(type));
    }

    private ModelReference modelReference(ResolvedType type) {
        if (Void.class.equals((Object)type.getErasedType()) || Void.TYPE.equals(type.getErasedType())) {
            return new ModelRef("void");
        }
        if (MultipartFile.class.isAssignableFrom(type.getErasedType())) {
            return new ModelRef("__file");
        }
        String typeName = this.typeName(type);
        return new ModelRef(typeName, type.getBriefDescription(), null, ResolvedTypes.allowableValues(type), this.modelId(ModelContext.fromParent((ModelContext)this.parentContext, (ResolvedType)type)));
    }

    private Optional<ModelReference> mapReference(ResolvedType type) {
        if (Maps.isMapType(type)) {
            ResolvedType mapValueType = Maps.mapValueType(type);
            return Optional.of(new ModelRef(this.typeName(type), this.apply(mapValueType), true));
        }
        return Optional.empty();
    }

    private Optional<ModelReference> collectionReference(ResolvedType type) {
        if (Collections.isContainerType(type)) {
            ResolvedType collectionElementType = Collections.collectionElementType(type);
            return Optional.of(new ModelRef(this.typeName(type), null, this.apply(collectionElementType), ResolvedTypes.allowableValues(collectionElementType), null));
        }
        return Optional.empty();
    }

    private String typeName(ResolvedType type) {
        ModelContext context = ModelContext.fromParent((ModelContext)this.parentContext, (ResolvedType)type);
        return this.typeNameExtractor.typeName(context, this.knownNames);
    }

    private String modelId(ModelContext context) {
        ResolvedType type = context.getType();
        if (type instanceof ResolvedPrimitiveType || Types.isBaseType(type) || Types.isVoid(type) || this.enumTypeDeterminer.isEnum(type.getErasedType())) {
            return null;
        }
        return context.getModelId();
    }
}

