/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Qualifier(value="cachedModels")
public class CachingModelProvider
implements ModelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingModelProvider.class);
    private final Map<ModelContext, Optional<Model>> cache;
    private final Function<ModelContext, Optional<Model>> lookup;
    private final ModelProvider delegate;

    @Autowired
    public CachingModelProvider(@Qualifier(value="default") ModelProvider delegate) {
        this.delegate = delegate;
        this.cache = new HashMap<ModelContext, Optional<Model>>();
        this.lookup = delegate::modelFor;
    }

    @Override
    public Optional<Model> modelFor(ModelContext modelContext) {
        try {
            return this.cache.computeIfAbsent(modelContext, this.lookup);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get the model for -> {}. {}", (Object)modelContext.description(), (Object)e.getMessage());
            return Optional.empty();
        }
    }

    @Override
    public Map<ResolvedType, Model> dependencies(ModelContext modelContext) {
        return this.delegate.dependencies(modelContext);
    }
}

