/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.DocumentationReference;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.Server;
import springfox.documentation.service.Tag;
import springfox.documentation.service.VendorExtension;

public class Documentation {
    private final String groupName;
    private final String basePath;
    private final Map<String, List<ApiListing>> apiListings;
    private final Set<Tag> tags;
    private final ResourceListing resourceListing;
    private final Set<String> produces;
    private final Set<String> consumes;
    private final String host;
    private final Set<String> schemes;
    private final List<Server> servers;
    private final DocumentationReference documentationReference;
    private final List<VendorExtension> vendorExtensions;

    public Documentation(String groupName, String basePath, Set<Tag> tags, Map<String, List<ApiListing>> apiListings, ResourceListing resourceListing, Set<String> produces, Set<String> consumes, String host, Set<String> schemes, List<Server> servers, DocumentationReference documentationReference, Collection<VendorExtension> vendorExtensions) {
        this.groupName = groupName;
        this.basePath = basePath;
        this.tags = tags;
        this.apiListings = apiListings;
        this.resourceListing = resourceListing;
        this.produces = produces;
        this.consumes = consumes;
        this.host = host;
        this.schemes = schemes;
        this.servers = servers;
        this.documentationReference = documentationReference;
        this.vendorExtensions = new ArrayList<VendorExtension>(vendorExtensions);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Map<String, List<ApiListing>> getApiListings() {
        return this.apiListings;
    }

    public ResourceListing getResourceListing() {
        return this.resourceListing;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public List<String> getProduces() {
        return new ArrayList<String>(this.produces);
    }

    public String getHost() {
        return this.host;
    }

    public List<String> getSchemes() {
        return new ArrayList<String>(this.schemes);
    }

    public List<String> getConsumes() {
        return new ArrayList<String>(this.consumes);
    }

    public List<VendorExtension> getVendorExtensions() {
        return this.vendorExtensions;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public DocumentationReference getDocumentationReference() {
        return this.documentationReference;
    }
}

