/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.DocumentationReference;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.Server;
import springfox.documentation.service.Tag;
import springfox.documentation.service.VendorExtension;

public class DocumentationBuilder {
    private String groupName;
    private Map<String, List<ApiListing>> apiListings = new TreeMap(Comparator.naturalOrder());
    private ResourceListing resourceListing;
    private Set<Tag> tags = new LinkedHashSet<Tag>();
    private String basePath;
    private Set<String> produces = new LinkedHashSet<String>();
    private Set<String> consumes = new LinkedHashSet<String>();
    private String host;
    private Set<String> schemes = new LinkedHashSet<String>();
    private List<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();
    private List<Server> servers = new ArrayList<Server>();
    private DocumentationReference documentationReference;

    public DocumentationBuilder name(String groupName) {
        this.groupName = BuilderDefaults.defaultIfAbsent(groupName, this.groupName);
        return this;
    }

    public DocumentationBuilder apiListingsByResourceGroupName(Map<String, List<ApiListing>> apiListings) {
        BuilderDefaults.nullToEmptyMultimap(apiListings).forEach((key, value) -> {
            List<Object> list;
            if (this.apiListings.containsKey(key)) {
                list = this.apiListings.get(key);
                list.addAll((Collection<Object>)value);
            } else {
                list = new ArrayList(value);
                this.apiListings.put((String)key, (List<ApiListing>)list);
            }
            list.sort(DocumentationBuilder.byListingPosition());
        });
        return this;
    }

    public DocumentationBuilder resourceListing(ResourceListing resourceListing) {
        this.resourceListing = BuilderDefaults.defaultIfAbsent(resourceListing, this.resourceListing);
        return this;
    }

    public DocumentationBuilder tags(Set<Tag> tags) {
        this.tags.addAll(BuilderDefaults.nullToEmptySet(tags));
        return this;
    }

    public DocumentationBuilder produces(Set<String> mediaTypes) {
        this.produces.addAll(BuilderDefaults.nullToEmptySet(mediaTypes));
        return this;
    }

    public DocumentationBuilder consumes(Set<String> mediaTypes) {
        this.consumes.addAll(BuilderDefaults.nullToEmptySet(mediaTypes));
        return this;
    }

    public DocumentationBuilder host(String host) {
        this.host = BuilderDefaults.defaultIfAbsent(host, this.host);
        return this;
    }

    public DocumentationBuilder schemes(Set<String> schemes) {
        this.schemes.addAll(BuilderDefaults.nullToEmptySet(schemes));
        return this;
    }

    public DocumentationBuilder basePath(String basePath) {
        this.basePath = BuilderDefaults.defaultIfAbsent(basePath, this.basePath);
        return this;
    }

    public DocumentationBuilder extensions(List<VendorExtension> extensions) {
        this.vendorExtensions.addAll(BuilderDefaults.nullToEmptyList(extensions));
        return this;
    }

    public DocumentationBuilder servers(List<Server> servers) {
        this.servers.addAll(BuilderDefaults.nullToEmptyList(servers));
        return this;
    }

    public DocumentationBuilder documentationReference(DocumentationReference documentationReference) {
        this.documentationReference = BuilderDefaults.defaultIfAbsent(documentationReference, this.documentationReference);
        return this;
    }

    public static Comparator<ApiListing> byListingPosition() {
        return Comparator.comparingInt(ApiListing::getPosition);
    }

    public Documentation build() {
        return new Documentation(this.groupName, this.basePath, this.tags, this.apiListings, this.resourceListing, this.produces, this.consumes, this.host, this.schemes, this.servers, this.documentationReference, this.vendorExtensions);
    }
}

