/*
 * Decompiled with CFR 0.152.
 */
package io.spring.nohttp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class RegexPredicate
implements Predicate<String> {
    private final List<Pattern> patterns;

    public RegexPredicate(List<Pattern> patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException("patterns cannot be null");
        }
        if (patterns.isEmpty()) {
            throw new IllegalArgumentException("patterns cannot be empty");
        }
        this.patterns = patterns;
    }

    @Override
    public boolean test(String httpText) {
        return this.patterns.stream().anyMatch(p -> p.matcher(httpText).matches());
    }

    public static Predicate<String> createDefaultUrlWhitelist() {
        InputStream resource = RegexPredicate.class.getResourceAsStream("whitelist.txt");
        return RegexPredicate.createWhitelistFromPatterns(resource);
    }

    public static Predicate<String> createWhitelistFromPatterns(InputStream resource) {
        List<Pattern> patterns = RegexPredicate.createPatternsFromInputStream(resource);
        return new RegexPredicate(patterns);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Pattern> createPatternsFromInputStream(InputStream resource) {
        if (resource == null) {
            throw new IllegalStateException("Failed to load whitelist from " + resource);
        }
        InputStreamReader input = new InputStreamReader(resource);
        try (BufferedReader reader = new BufferedReader(input);){
            List<Pattern> list = reader.lines().map(String::trim).filter(l -> !l.startsWith("//")).filter(l -> l.length() != 0).map(Pattern::compile).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

