/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IPermittedSubclassesAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IPermittedSubclassesAttributeEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.PermittedSubclassesAttributeEntry;

public class PermittedSubclassesAttribute
extends ClassFileAttribute
implements IPermittedSubclassesAttribute {
    private static final IPermittedSubclassesAttributeEntry[] NO_ENTRIES = new IPermittedSubclassesAttributeEntry[0];
    private int permittedSubclasses;
    private IPermittedSubclassesAttributeEntry[] entries;

    public PermittedSubclassesAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length = this.permittedSubclasses = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.entries = new IPermittedSubclassesAttributeEntry[length];
            int i = 0;
            while (i < length) {
                this.entries[i] = new PermittedSubclassesAttributeEntry(classFileBytes, constantPool, offset + readOffset);
                readOffset += 2;
                ++i;
            }
        } else {
            this.entries = NO_ENTRIES;
        }
    }

    @Override
    public IPermittedSubclassesAttributeEntry[] getPermittedSubclassAttributesEntries() {
        return this.entries;
    }
}

