/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ILocalVariableAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ILocalVariableTableEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.LocalVariableTableEntry;

public class LocalVariableAttribute
extends ClassFileAttribute
implements ILocalVariableAttribute {
    private static final ILocalVariableTableEntry[] NO_ENTRIES = new ILocalVariableTableEntry[0];
    private int localVariableTableLength;
    private ILocalVariableTableEntry[] localVariableTable;

    public LocalVariableAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length;
        this.localVariableTableLength = length = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.localVariableTable = new ILocalVariableTableEntry[length];
            int i = 0;
            while (i < length) {
                this.localVariableTable[i] = new LocalVariableTableEntry(classFileBytes, constantPool, offset + readOffset);
                readOffset += 10;
                ++i;
            }
        } else {
            this.localVariableTable = NO_ENTRIES;
        }
    }

    @Override
    public ILocalVariableTableEntry[] getLocalVariableTable() {
        return this.localVariableTable;
    }

    @Override
    public int getLocalVariableTableLength() {
        return this.localVariableTableLength;
    }
}

