/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.matching;

import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.core.search.SearchPattern;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.matching.ConstructorPattern;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.matching.MethodPattern;

public class MethodDeclarationPattern
extends MethodPattern {
    public int extraFlags;
    public int declaringTypeModifiers;
    public int modifiers;
    public char[] signature;
    public char[][] parameterTypes;
    public char[][] parameterNames;
    public char[] fusedDeclaringQualifier = null;

    public static char[] createDeclarationIndexKey(char[] typeName, char[] declaringQualification, char[] methodName, int argCount, char[] signature, char[][] parameterTypes, char[][] parameterNames, char[] returnType, int modifiers, char[] packageName, int typeModifiers, int extraFlags) {
        char[] countChars;
        char[] cArray;
        char[] parameterTypesChars = null;
        char[] parameterNamesChars = null;
        if (argCount < 10) {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = COUNTS[argCount][1];
        } else {
            cArray = countChars = String.valueOf(argCount).toCharArray();
        }
        if (argCount > 0) {
            if (signature == null) {
                if (parameterTypes != null && parameterTypes.length == argCount) {
                    parameterTypesChars = CharOperation.concatWith(parameterTypes, ',');
                }
            } else {
                extraFlags |= 0x10;
            }
            if (parameterNames != null && parameterNames.length == argCount) {
                parameterNamesChars = CharOperation.concatWith(parameterNames, ',');
            }
        }
        char[] returnTypeChars = returnType == null ? CharOperation.NO_CHAR : MethodDeclarationPattern.getTypeErasure(returnType);
        int typeModifiersWithExtraFlags = typeModifiers | MethodDeclarationPattern.encodeExtraFlags(extraFlags);
        int entryIndex = 0;
        int numEntries = 10;
        char[][] tmp = new char[numEntries][];
        tmp[entryIndex++] = methodName != null ? methodName : CharOperation.NO_CHAR;
        tmp[entryIndex++] = countChars;
        tmp[entryIndex++] = declaringQualification != null ? declaringQualification : CharOperation.NO_CHAR;
        tmp[entryIndex++] = typeName != null ? typeName : CharOperation.NO_CHAR;
        tmp[entryIndex++] = new char[]{(char)typeModifiersWithExtraFlags, (char)(typeModifiersWithExtraFlags >> 16)};
        char[] cArray3 = tmp[entryIndex++] = packageName != null ? packageName : CharOperation.NO_CHAR;
        if (argCount == 0) {
            tmp[entryIndex++] = CharOperation.NO_CHAR;
            tmp[entryIndex++] = CharOperation.NO_CHAR;
        } else if (argCount > 0) {
            tmp[entryIndex++] = signature != null ? CharOperation.replaceOnCopy(signature, '/', '\\') : (parameterTypesChars != null ? parameterTypesChars : CharOperation.NO_CHAR);
            tmp[entryIndex++] = parameterNamesChars != null ? parameterNamesChars : CharOperation.NO_CHAR;
        }
        tmp[entryIndex++] = new char[]{(char)modifiers, (char)(modifiers >> 16)};
        tmp[entryIndex] = returnTypeChars;
        return CharOperation.concatWithAll(tmp, '/');
    }

    private static int encodeExtraFlags(int extraFlags) {
        int encodedExtraFlags = 0;
        if ((extraFlags & 0x10) != 0) {
            encodedExtraFlags |= 0x8000000;
        }
        if ((extraFlags & 4) != 0) {
            encodedExtraFlags |= 0x10000000;
        }
        if ((extraFlags & 2) != 0) {
            encodedExtraFlags |= 0x20000000;
        }
        if ((extraFlags & 1) != 0) {
            encodedExtraFlags |= 0x40000000;
        }
        return encodedExtraFlags;
    }

    private static char[] getTypeErasure(char[] typeName) {
        int index = CharOperation.indexOf('<', typeName);
        if (index == -1) {
            return typeName;
        }
        int length = typeName.length;
        char[] typeErasurename = new char[length - 2];
        System.arraycopy(typeName, 0, typeErasurename, 0, index);
        int depth = 1;
        int i = index + 1;
        while (i < length) {
            switch (typeName[i]) {
                case '<': {
                    ++depth;
                    break;
                }
                case '>': {
                    --depth;
                    break;
                }
                default: {
                    if (depth != 0) break;
                    typeErasurename[index++] = typeName[i];
                }
            }
            ++i;
        }
        char[] cArray = typeErasurename;
        typeErasurename = new char[index];
        System.arraycopy(cArray, 0, typeErasurename, 0, index);
        return typeErasurename;
    }

    public MethodDeclarationPattern(int matchRule) {
        super(matchRule);
    }

    @Override
    public void decodeIndexKey(char[] key) {
        int start = 0;
        int slash = CharOperation.indexOf('/', key, start);
        this.selector = CharOperation.subarray(key, start, slash);
        start = slash + 1;
        slash = CharOperation.indexOf('/', key, start);
        int last = slash - 1;
        this.parameterCount = 0;
        int power = 1;
        int i = last;
        while (i >= start) {
            this.parameterCount = i == last ? key[i] - 48 : (this.parameterCount += (power *= 10) * (key[i] - 48));
            --i;
        }
        start = slash + 1;
        slash = CharOperation.indexOf('/', key, start);
        this.declaringQualification = CharOperation.subarray(key, start, slash);
        start = slash + 1;
        slash = CharOperation.indexOf('/', key, start);
        this.declaringSimpleName = CharOperation.subarray(key, start, slash);
        start = slash + 1;
        slash = CharOperation.indexOf('/', key, start);
        last = slash - 1;
        int typeModifiersWithExtraFlags = key[last - 1] + (key[last] << 16);
        this.declaringTypeModifiers = ConstructorPattern.decodeModifers(typeModifiersWithExtraFlags);
        this.extraFlags = ConstructorPattern.decodeExtraFlags(typeModifiersWithExtraFlags);
        this.declaringPackageName = null;
        this.modifiers = 0;
        this.signature = null;
        this.parameterTypes = null;
        this.parameterNames = null;
        start = slash + 1;
        slash = CharOperation.indexOf('/', key, start);
        this.declaringPackageName = CharOperation.subarray(key, start, slash);
        start = slash + 1;
        slash = CharOperation.indexOf('/', key, start);
        if (this.parameterCount == 0) {
            start = slash + 1;
            slash = CharOperation.indexOf('/', key, start);
            start = slash + 1;
            slash = CharOperation.indexOf('/', key, start);
            this.modifiers = key[last - 1] + (key[last] << 16);
        } else if (this.parameterCount > 0) {
            boolean hasParameterStoredAsSignature;
            boolean bl = hasParameterStoredAsSignature = (this.extraFlags & 0x10) != 0;
            if (hasParameterStoredAsSignature) {
                this.signature = CharOperation.subarray(key, start, slash);
                CharOperation.replace(this.signature, '\\', '/');
            } else {
                this.parameterTypes = CharOperation.splitOnWithEnclosures(',', '<', '>', key, start, slash);
            }
            start = slash + 1;
            slash = CharOperation.indexOf('/', key, start);
            if (slash != start) {
                this.parameterNames = CharOperation.splitOn(',', key, start, slash);
            }
            start = slash + 1;
            slash = CharOperation.indexOf('/', key, start);
            last = slash - 1;
            this.modifiers = key[last - 1] + (key[last] << 16);
        } else {
            this.modifiers = 1;
        }
        start = slash + 1;
        slash = CharOperation.indexOf('/', key, start);
        this.returnSimpleName = CharOperation.subarray(key, start, slash);
        this.removeInternalFlags();
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new MethodDeclarationPattern(8);
    }

    @Override
    public char[][] getIndexCategories() {
        return new char[][]{METHOD_DECL_PLUS};
    }

    private void removeInternalFlags() {
        this.extraFlags &= 0xFFFFFFEF;
    }
}

